/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.utils;

import com.mojang.authlib.GameProfile;
import com.swdteam.utils.DMUtils;
import com.swdteam.utils.EnumDefaultResponse;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class PlayerUtils {

    public static class Auth {
        public static boolean isOp(String name) {
            return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152603_m().func_152700_a(name) != null;
        }

        public static boolean isOp(EntityPlayer player) {
            String name = player.func_70005_c_();
            return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152603_m().func_152700_a(name) != null;
        }

        public static boolean doUUIDsMatch(EntityPlayer player, String ... uuid) {
            String playerUUID = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()).toString();
            for (String s : uuid) {
                if (!playerUUID.contains(s)) continue;
                return playerUUID.contains(s);
            }
            return false;
        }

        public static String getName(UUID uuid) {
            return DMUtils.getName(uuid.toString());
        }

        public static String getPlayerUUID(EntityPlayer player) {
            return player.func_146103_bH().getId().toString();
        }

        public static String getUUID(String player) {
            String strUUID = DMUtils.getUUIDs(player);
            return strUUID;
        }
    }

    public static class Messaging {
        public static void sendMessageToPlayer(EntityPlayer p, String s) {
            TextComponentString textComponent = new TextComponentString(s);
            p.func_145747_a((ITextComponent)textComponent);
        }

        public static void sendMessageToPlayer(EntityPlayer p, EnumDefaultResponse s) {
            TextComponentTranslation textComponent = new TextComponentTranslation(s.name, new Object[0]);
            p.func_145747_a((ITextComponent)textComponent);
        }

        public static void sendStatusMessageToPlayer(EntityPlayer p, String s, boolean actionBar) {
            TextComponentString textComponent = new TextComponentString(s);
            p.func_146105_b((ITextComponent)textComponent, actionBar);
        }
    }

    public static class Hands {
        public static boolean isInHand(EnumHand hand, EntityPlayer holder, ItemStack item) {
            if (holder.func_184586_b(hand) != null) {
                ItemStack heldItem = holder.func_184586_b(hand);
                return heldItem.func_77969_a(item);
            }
            return false;
        }

        public static boolean isInMainHand(EntityPlayer holder, Item item) {
            return Hands.isInHand(EnumHand.MAIN_HAND, holder, new ItemStack(item));
        }

        public static boolean isInOffHand(EntityPlayer holder, Item item) {
            return Hands.isInHand(EnumHand.OFF_HAND, holder, new ItemStack(item));
        }

        public static boolean isInEitherHand(EntityPlayer holder, Item item) {
            return Hands.isInMainHand(holder, item) || Hands.isInOffHand(holder, item);
        }

        public static boolean isInOneHand(EntityPlayer holder, Item item) {
            boolean mainHand = Hands.isInMainHand(holder, item) && !Hands.isInOffHand(holder, item);
            boolean offHand = Hands.isInOffHand(holder, item) && !Hands.isInMainHand(holder, item);
            return mainHand || offHand;
        }
    }
}

