/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.world.gen.chunk;

import com.swdteam.common.world.gen.terrain.TerrainGenerator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class ChunkGeneratorBase
implements IChunkGenerator {
    public final World worldObj;
    public Random random;
    public Biome[] biomesForGeneration;
    private MapGenBase caveGenerator = new MapGenCaves();
    public TerrainGenerator terraingen = new TerrainGenerator();

    public ChunkGeneratorBase(World worldObj, Biome b) {
        this.worldObj = worldObj;
        long seed = worldObj.func_72905_C();
        this.random = new Random((seed + 516L) * 314L);
        this.terraingen.setup(worldObj, this.random);
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.caveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.biomesForGeneration = new Biome[]{b};
        this.terraingen.setBiomeToGenerate(b);
    }

    public void func_185931_b(int x, int z) {
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.worldObj.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        biome.func_180624_a(this.worldObj, this.random, blockpos);
        WorldEntitySpawner.func_77191_a((World)this.worldObj, (Biome)biome, (int)(i + 8), (int)(j + 8), (int)16, (int)16, (Random)this.random);
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public Chunk func_185932_a(int x, int z) {
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, x * 4 - 2, z * 4 - 2, 10, 10);
        this.terraingen.generate(x, z, chunkprimer);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.terraingen.replaceBiomeBlocks(x, z, chunkprimer, this, this.biomesForGeneration);
        this.caveGenerator.func_186125_a(this.worldObj, x, z, chunkprimer);
        Chunk chunk = new Chunk(this.worldObj, chunkprimer, x, z);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < biomeArray.length; ++i) {
            biomeArray[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return null;
    }
}

