/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.block;

import com.swdteam.common.block.actions.ActionList;
import com.swdteam.common.init.DMCreativeTabs;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDMMetadata
extends Block {
    public static PropertyInteger TYPE = PropertyInteger.func_177719_a((String)"type", (int)0, (int)15);
    public int subBlockNum;
    public String path;
    private boolean isTardisDoor = false;
    private int[] opaque_map = new int[16];

    public BlockDMMetadata(Material m, int sbn, String pth) {
        super(m);
        this.func_149711_c(0.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(2)));
        this.subBlockNum = sbn;
        this.path = pth;
        this.func_149647_a(DMCreativeTabs.TAB_TARDIS_BLOCKS);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public Block setOpaqueMap(int ... index) {
        for (int i = 0; i < index.length; ++i) {
            this.opaque_map[i] = index[i];
        }
        return this;
    }

    public int[] getOpaqueMap() {
        return this.opaque_map;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        if (this.opaque_map == null || state == null) {
            return false;
        }
        return this.opaque_map[this.func_176201_c(state)] != 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> list) {
        for (int j = 0; j < this.subBlockNum; ++j) {
            list.add((Object)new ItemStack((Block)this, 1, j));
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(meta));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(world.func_180495_p(pos).func_177230_c(), 1, this.func_176201_c(world.func_180495_p(pos)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)TYPE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.isTardisDoor()) {
            return ActionList.tardisDoorExit(worldIn, pos, state, playerIn, facing, hitZ, hitZ, hitZ);
        }
        return false;
    }

    public boolean isTardisDoor() {
        return this.isTardisDoor;
    }

    public Block setTardisDoor(boolean isTardisDoor) {
        this.isTardisDoor = isTardisDoor;
        return this;
    }
}

