/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.utils;

import com.mojang.authlib.GameProfile;
import com.swdteam.common.entity.EntityChair;
import com.swdteam.utils.DMUtils;
import com.swdteam.utils.EnumDefaultResponse;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class PlayerUtils {
    public static boolean isInHand(EnumHand hand, EntityPlayer holder, ItemStack item) {
        if (holder.func_184586_b(hand) != null) {
            ItemStack heldItem = holder.func_184586_b(hand);
            return heldItem.func_77969_a(item);
        }
        return false;
    }

    public static boolean sitOnBlock(World par1World, double x, double y, double z, EntityPlayer par5EntityPlayer, double par6) {
        if (!PlayerUtils.checkForExistingEntity(par1World, x, y, z, par5EntityPlayer)) {
            EntityChair nemb = new EntityChair(par1World, x, y, z, par6);
            par1World.func_72838_d((Entity)nemb);
            par5EntityPlayer.func_184220_m((Entity)nemb);
        }
        return true;
    }

    public static boolean checkForExistingEntity(World par1World, double x, double y, double z, EntityPlayer par5EntityPlayer) {
        List listEMB = par1World.func_72872_a(EntityChair.class, new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0).func_72314_b(1.0, 1.0, 1.0));
        for (EntityChair mount : listEMB) {
            if ((double)mount.blockPosX != x || (double)mount.blockPosY != y || (double)mount.blockPosZ != z) continue;
            if (!mount.func_184207_aI()) {
                par5EntityPlayer.func_184220_m((Entity)mount);
            }
            return true;
        }
        return false;
    }

    public static boolean isSomeoneSitting(World world, double x, double y, double z) {
        List listEMB = world.func_72872_a(EntityChair.class, new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0).func_72314_b(1.0, 1.0, 1.0));
        for (EntityChair mount : listEMB) {
            if ((double)mount.blockPosX != x || (double)mount.blockPosY != y || (double)mount.blockPosZ != z) continue;
            return mount.func_184207_aI();
        }
        return false;
    }

    public static boolean isInMainHand(EntityPlayer holder, Item item) {
        return PlayerUtils.isInHand(EnumHand.MAIN_HAND, holder, new ItemStack(item));
    }

    public static boolean isInOffHand(EntityPlayer holder, Item item) {
        return PlayerUtils.isInHand(EnumHand.OFF_HAND, holder, new ItemStack(item));
    }

    public static boolean isInEitherHand(EntityPlayer holder, Item item) {
        return PlayerUtils.isInMainHand(holder, item) || PlayerUtils.isInOffHand(holder, item);
    }

    public static boolean isInOneHand(EntityPlayer holder, Item item) {
        boolean mainHand = PlayerUtils.isInMainHand(holder, item) && !PlayerUtils.isInOffHand(holder, item);
        boolean offHand = PlayerUtils.isInOffHand(holder, item) && !PlayerUtils.isInMainHand(holder, item);
        return mainHand || offHand;
    }

    public static boolean isOp(String name) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152603_m().func_152700_a(name) != null;
    }

    public static boolean isOp(EntityPlayer player) {
        String name = player.func_70005_c_();
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152603_m().func_152700_a(name) != null;
    }

    public static void sendMessageToPlayer(EntityPlayer p, String s) {
        TextComponentString textComponent = new TextComponentString(s);
        p.func_145747_a((ITextComponent)textComponent);
    }

    public static void sendMessageToPlayer(EntityPlayer p, EnumDefaultResponse s) {
        TextComponentTranslation textComponent = new TextComponentTranslation(s.name, new Object[0]);
        p.func_145747_a((ITextComponent)textComponent);
    }

    public static boolean doUUIDsMatch(EntityPlayer player, String ... uuid) {
        String playerUUID = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()).toString();
        for (String s : uuid) {
            if (!playerUUID.contains(s)) continue;
            return playerUUID.contains(s);
        }
        return false;
    }

    public static void sendStatusMessageToPlayer(EntityPlayer p, String s, boolean actionBar) {
        TextComponentString textComponent = new TextComponentString(s);
        p.func_146105_b((ITextComponent)textComponent, actionBar);
    }

    public static String getName(UUID uuid) {
        return DMUtils.getName(uuid.toString());
    }

    public static String getPlayerUUID(EntityPlayer player) {
        return player.func_146103_bH().getId().toString();
    }

    public static String getUUID(String player) {
        String strUUID = DMUtils.getUUIDs(player);
        return strUUID;
    }

    public static boolean canReallySee(EntityLivingBase entity, EntityLivingBase target, boolean alsoRaytrace) {
        if (alsoRaytrace && !entity.func_70685_l((Entity)target)) {
            return false;
        }
        Vec3d look1 = new Vec3d(-Math.sin((double)(entity.field_70759_as / 180.0f) * Math.PI), 0.0, Math.cos((double)(entity.field_70759_as / 180.0f) * Math.PI));
        Vec3d dist = new Vec3d(target.field_70165_t - entity.field_70165_t, 0.0, target.field_70161_v - entity.field_70161_v);
        double alpha = Math.acos((look1 = look1.func_72432_b()).func_72430_b(dist = dist.func_72432_b()));
        return alpha < 1.7453292519943295;
    }
}

