/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.utils.model.techne;

import com.swdteam.client.init.DMTCNModelLoader;
import com.swdteam.utils.Graphics;
import com.swdteam.utils.model.IModelCustom;
import com.swdteam.utils.model.ModelFormatException;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@SideOnly(value=Side.CLIENT)
public class TechneModel
extends ModelBase
implements IModelCustom {
    public static final List<String> cubeTypes = Arrays.asList("d9e621f7-957f-4b77-b1ae-20dcd0da7751", "de81aa14-bd60-4228-8d8d-5238bcd3caaa");
    private String fileName;
    private Map<String, byte[]> zipContents = new HashMap<String, byte[]>();
    public Map<String, ModelRenderer> parts = new LinkedHashMap<String, ModelRenderer>();
    private String texture = null;
    public int textureName;
    private boolean textureNameSet = false;

    public TechneModel() {
    }

    public TechneModel(ResourceLocation resource) throws ModelFormatException {
        this.fileName = resource.toString();
        try {
            IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(resource);
            this.loadTechneModel(res.func_110527_b());
        }
        catch (Exception e) {
            throw new ModelFormatException("IO Exception reading model format", e);
        }
    }

    public TechneModel(InputStream stream) {
        this.loadTechneModel(stream);
    }

    public void loadTechneModel(InputStream stream) throws ModelFormatException {
        try {
            ZipEntry entry;
            ZipInputStream zipInput = new ZipInputStream(stream);
            while ((entry = zipInput.getNextEntry()) != null) {
                byte[] data = new byte[(int)entry.getSize()];
                int i = 0;
                while (zipInput.available() > 0 && i < data.length) {
                    data[i++] = (byte)zipInput.read();
                }
                this.zipContents.put(entry.getName(), data);
            }
            byte[] modelXml = this.zipContents.get("model.xml");
            if (modelXml == null) {
                System.out.println(new ModelFormatException("Model " + this.fileName + " contains no model.xml file").getMessage());
                return;
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(modelXml));
            NodeList nodeListTechne = document.getElementsByTagName("Techne");
            if (nodeListTechne.getLength() < 1) {
                throw new ModelFormatException("Model " + this.fileName + " contains no Techne tag");
            }
            NodeList nodeListModel = document.getElementsByTagName("Model");
            if (nodeListModel.getLength() < 1) {
                throw new ModelFormatException("Model " + this.fileName + " contains no Model tag");
            }
            NamedNodeMap modelAttributes = nodeListModel.item(0).getAttributes();
            if (modelAttributes == null) {
                throw new ModelFormatException("Model " + this.fileName + " contains a Model tag with no attributes");
            }
            Node modelTexture = modelAttributes.getNamedItem("texture");
            if (modelTexture != null) {
                this.texture = modelTexture.getTextContent();
            }
            NodeList textureSize = document.getElementsByTagName("TextureSize");
            for (int i = 0; i < textureSize.getLength(); ++i) {
                String size = textureSize.item(i).getTextContent();
                String[] textureDimensions = size.split(",");
                this.field_78090_t = Integer.parseInt(textureDimensions[0]);
                this.field_78089_u = Integer.parseInt(textureDimensions[1]);
            }
            NodeList shapes = document.getElementsByTagName("Shape");
            for (int i = 0; i < shapes.getLength(); ++i) {
                Node shape = shapes.item(i);
                NamedNodeMap shapeAttributes = shape.getAttributes();
                if (shapeAttributes == null) {
                    throw new ModelFormatException("Shape #" + (i + 1) + " in " + this.fileName + " has no attributes");
                }
                Node name = shapeAttributes.getNamedItem("name");
                String shapeName = null;
                if (name != null) {
                    shapeName = name.getNodeValue();
                }
                if (shapeName == null) {
                    shapeName = "Shape #" + (i + 1);
                }
                String shapeType = null;
                Node type = shapeAttributes.getNamedItem("type");
                if (type != null) {
                    shapeType = type.getNodeValue();
                }
                if (shapeType != null && !cubeTypes.contains(shapeType)) {
                    FMLLog.warning((String)("Model shape [" + shapeName + "] in " + this.fileName + " is not a cube, ignoring"), (Object[])new Object[0]);
                    continue;
                }
                try {
                    boolean mirrored = false;
                    String[] offset = new String[3];
                    String[] position = new String[3];
                    String[] rotation = new String[3];
                    String[] size = new String[3];
                    String[] textureOffset = new String[2];
                    NodeList shapeChildren = shape.getChildNodes();
                    for (int j = 0; j < shapeChildren.getLength(); ++j) {
                        Node shapeChild = shapeChildren.item(j);
                        String shapeChildName = shapeChild.getNodeName();
                        String shapeChildValue = shapeChild.getTextContent();
                        if (shapeChildValue == null) continue;
                        shapeChildValue = shapeChildValue.trim();
                        if (shapeChildName.equals("IsMirrored")) {
                            mirrored = !shapeChildValue.equals("False");
                            continue;
                        }
                        if (shapeChildName.equals("Offset")) {
                            offset = shapeChildValue.split(",");
                            continue;
                        }
                        if (shapeChildName.equals("Position")) {
                            position = shapeChildValue.split(",");
                            continue;
                        }
                        if (shapeChildName.equals("Rotation")) {
                            rotation = shapeChildValue.split(",");
                            continue;
                        }
                        if (shapeChildName.equals("Size")) {
                            size = shapeChildValue.split(",");
                            continue;
                        }
                        if (!shapeChildName.equals("TextureOffset")) continue;
                        textureOffset = shapeChildValue.split(",");
                    }
                    ModelRenderer cube = new ModelRenderer((ModelBase)this, shapeName);
                    cube.func_78784_a(Integer.parseInt(textureOffset[0]), Integer.parseInt(textureOffset[1]));
                    cube.field_78809_i = mirrored;
                    cube.func_78789_a(Float.parseFloat(offset[0]), Float.parseFloat(offset[1]), Float.parseFloat(offset[2]), Integer.parseInt(size[0]), Integer.parseInt(size[1]), Integer.parseInt(size[2]));
                    cube.func_78793_a(Float.parseFloat(position[0]), Float.parseFloat(position[1]) - 16.0f, Float.parseFloat(position[2]));
                    cube.field_78795_f = (float)Math.toRadians(Float.parseFloat(rotation[0]));
                    cube.field_78796_g = (float)Math.toRadians(Float.parseFloat(rotation[1]));
                    cube.field_78808_h = (float)Math.toRadians(Float.parseFloat(rotation[2]));
                    if (this.parts.containsKey(shapeName)) {
                        this.parts.put(shapeName + System.nanoTime(), cube);
                        continue;
                    }
                    this.parts.put(shapeName, cube);
                    continue;
                }
                catch (NumberFormatException e) {
                    FMLLog.warning((String)("Model shape [" + shapeName + "] in " + this.fileName + " contains malformed integers within its data, ignoring"), (Object[])new Object[0]);
                    e.printStackTrace();
                }
            }
        }
        catch (ZipException e) {
            throw new ModelFormatException("Model " + this.fileName + " is not a valid zip file");
        }
        catch (IOException e) {
            throw new ModelFormatException("Model " + this.fileName + " could not be read", e);
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXException e) {
            throw new ModelFormatException("Model " + this.fileName + " contains invalid XML", e);
        }
    }

    private void bindTexture() {
        if (this.texture != null) {
            if (!this.textureNameSet) {
                try {
                    byte[] textureEntry = this.zipContents.get(this.texture);
                    if (textureEntry == null) {
                        this.textureName = DMTCNModelLoader.defaultTexture;
                        this.textureNameSet = true;
                    } else {
                        BufferedImage image = ImageIO.read(new ByteArrayInputStream(textureEntry));
                        this.textureName = Graphics.loadTexture(image);
                        this.textureNameSet = true;
                    }
                }
                catch (ZipException e) {
                    throw new ModelFormatException("Model " + this.fileName + " is not a valid zip file");
                }
                catch (IOException e) {
                    throw new ModelFormatException("Texture for model " + this.fileName + " could not be read", e);
                }
            }
            if (this.textureNameSet) {
                Graphics.bindTexture(this.textureName);
            }
        }
    }

    @Override
    public String getType() {
        return "tcn";
    }

    private void setup() {
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
    }

    @Override
    public void renderAll() {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.bindTexture();
        GL11.glTexParameterf((int)3553, (int)10240, (float)9728.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)-1.1f, (float)0.0f);
        GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
        this.setup();
        for (ModelRenderer part : this.parts.values()) {
            part.func_78791_b(0.0625f);
        }
        Graphics.bindTexture(TextureMap.field_174945_f);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    @Override
    public void renderPart(String partName) {
        ModelRenderer part = this.parts.get(partName);
        if (part != null) {
            GL11.glPushMatrix();
            this.setup();
            this.bindTexture();
            part.func_78785_a(0.0625f);
            GL11.glPopMatrix();
        }
    }

    @Override
    public void renderOnly(String ... groupNames) {
        GL11.glPushMatrix();
        this.setup();
        this.bindTexture();
        for (Map.Entry<String, ModelRenderer> entry : this.parts.entrySet()) {
            for (String groupName : groupNames) {
                if (!entry.getKey().equalsIgnoreCase(groupName)) continue;
                entry.getValue().func_78785_a(0.0625f);
            }
        }
        GL11.glPopMatrix();
    }

    public void renderOnlyAroundPivot(double angle, double rotX, double rotY, double rotZ, String ... groupNames) {
        GL11.glPushMatrix();
        this.setup();
        this.bindTexture();
        for (Map.Entry<String, ModelRenderer> entry : this.parts.entrySet()) {
            for (String groupName : groupNames) {
                if (!entry.getKey().equalsIgnoreCase(groupName)) continue;
                GL11.glPushMatrix();
                ModelRenderer model = entry.getValue();
                GL11.glTranslatef((float)(model.field_78800_c / 16.0f), (float)(model.field_78797_d / 16.0f), (float)(model.field_78798_e / 16.0f));
                GL11.glRotated((double)angle, (double)rotX, (double)rotY, (double)rotZ);
                GL11.glTranslatef((float)(-model.field_78800_c / 16.0f), (float)(-model.field_78797_d / 16.0f), (float)(-model.field_78798_e / 16.0f));
                model.func_78785_a(0.0625f);
                GL11.glPopMatrix();
            }
        }
        GL11.glPopMatrix();
    }

    @Override
    public void renderAllExcept(String ... excludedGroupNames) {
        GL11.glPushMatrix();
        this.setup();
        block0: for (Map.Entry<String, ModelRenderer> entry : this.parts.entrySet()) {
            for (String groupName : excludedGroupNames) {
                if (entry.getKey().equalsIgnoreCase(groupName)) continue block0;
            }
            entry.getValue().func_78785_a(0.0625f);
        }
        GL11.glPopMatrix();
    }

    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.renderAll();
    }
}

