/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.tileentity.tardis;

import com.swdteam.common.dimensions.DMDimensions;
import com.swdteam.common.entity.EntityWeepingAngel;
import com.swdteam.common.init.DMTardis;
import com.swdteam.common.sound_events.DMSoundEvents;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tardis.data.chameleon.ChameleonCircuitBase;
import com.swdteam.common.tileentity.DMTileEntityBase;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_RequestTardisData;
import com.swdteam.network.packets.Packet_TardisDoors;
import com.swdteam.utils.TeleportUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityTardis
extends DMTileEntityBase
implements ITickable {
    public int tardisID;
    public int pulses = -1;
    public boolean isDemat = false;
    public boolean isRemat = false;
    public boolean b1;
    public float dematAmount = 1.0f;
    public float scale = 1.0f;
    public TardisData tempTardisData;
    public boolean requestingData;
    public static AxisAlignedBB defaultAABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("tardis_id", this.tardisID);
        compound.func_74757_a("isDemat", this.isDemat);
        compound.func_74757_a("isRemat", this.isRemat);
        compound.func_74776_a("dematAmount", this.dematAmount);
        compound.func_74776_a("scale", this.scale);
        compound.func_74768_a("pulses", this.pulses);
        compound.func_74757_a("b1", this.b1);
        if (this.tempTardisData != null && !this.field_145850_b.field_72995_K) {
            TardisSaveHandler.saveTardis(this.tempTardisData);
        }
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tardisID = compound.func_74764_b("tardis_id") ? compound.func_74762_e("tardis_id") : 0;
        this.isDemat = compound.func_74764_b("isDemat") ? compound.func_74767_n("isDemat") : false;
        this.isRemat = compound.func_74764_b("isRemat") ? compound.func_74767_n("isRemat") : false;
        this.dematAmount = compound.func_74764_b("dematAmount") ? compound.func_74760_g("dematAmount") : 0.0f;
        this.scale = compound.func_74764_b("scale") ? compound.func_74760_g("scale") : 1.0f;
        this.pulses = compound.func_74764_b("pulses") ? compound.func_74762_e("pulses") : 0;
        this.b1 = compound.func_74764_b("b1") ? compound.func_74767_n("b1") : false;
        if (this.field_145850_b != null) {
            this.tempTardisData = DMTardis.getTardis(!this.field_145850_b.field_72995_K, this.tardisID);
        }
    }

    public void func_73660_a() {
        if (this.tempTardisData == null) {
            this.tempTardisData = DMTardis.getTardis(!this.field_145850_b.field_72995_K, this.tardisID);
        }
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && !this.requestingData) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_RequestTardisData(this.tardisID));
            this.requestingData = true;
        }
        if (this.tempTardisData == null) {
            return;
        }
        ChameleonCircuitBase base = this.getSkin(this.tempTardisData);
        if (this.tempTardisData.isDoorOpen() && this.tempTardisData.getDoorRotation() < base.maxDoorRotation()) {
            this.tempTardisData.setDoorRotation(this.tempTardisData.getDoorRotation() + base.doorOpenSpeed());
        } else {
            if (!this.tempTardisData.isDoorOpen() && this.tempTardisData.getDoorRotation() > 0.0f) {
                this.tempTardisData.setDoorRotation(this.tempTardisData.getDoorRotation() - base.doorCloseSpeed());
            }
            if (this.tempTardisData.getDoorRotation() < 0.0f) {
                this.tempTardisData.setDoorRotation(0.0f);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            AxisAlignedBB bounds = defaultAABB.func_186670_a(this.func_174877_v());
            AxisAlignedBB boundsextended = defaultAABB.func_72321_a(10.0, 10.0, 10.0);
            List players = this.field_145850_b.func_72872_a(EntityPlayer.class, bounds);
            List angels = this.field_145850_b.func_72872_a(EntityWeepingAngel.class, boundsextended);
            if (angels != null && angels.size() > 0) {
                System.out.println(angels.size());
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), DMSoundEvents.CloisterBell, SoundCategory.MASTER, 1.0f, 1.0f, false);
            }
            if (players != null && players.size() > 0 && this.tempTardisData.isDoorOpen()) {
                this.tempTardisData = DMTardis.getTardis(this.tardisID);
                base.handleEnter(this.field_145850_b, this.field_174879_c, this, (Entity)players.get(0));
            }
        }
        if (this.isDemat || this.isRemat) {
            if (this.pulses == -1) {
                if (this.isRemat) {
                    this.b1 = true;
                }
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), this.isDemat ? DMSoundEvents.tardisDemat : DMSoundEvents.tardisRemat, SoundCategory.MASTER, 1.0f, 1.0f, false);
                this.pulses = 0;
            }
            if (!this.b1) {
                this.dematAmount -= 0.05f;
                if (this.dematAmount <= 0.2f) {
                    this.b1 = !this.b1;
                    ++this.pulses;
                }
            } else {
                this.dematAmount += 0.05f;
                if (this.dematAmount >= 1.0f) {
                    this.b1 = !this.b1;
                    ++this.pulses;
                }
            }
        }
        if (this.pulses >= 13) {
            if (this.isDemat) {
                this.field_145850_b.func_175698_g(this.func_174877_v());
                this.isDemat = false;
                this.isRemat = false;
                this.pulses = -1;
                this.dematAmount = 0.0f;
            }
            if (this.isRemat) {
                this.finishRemat();
            }
        }
    }

    public void finishRemat() {
        if (this.tempTardisData != null) {
            this.tempTardisData.setInFlight(false);
            this.tempTardisData.setTardisPreviousDimensionLocation(this.field_145850_b.field_73011_w.getDimension());
            this.tempTardisData.setPreviousLocationName(this.field_145850_b.field_73011_w.func_186058_p().func_186065_b());
            if (!this.field_145850_b.field_72995_K) {
                TardisSaveHandler.saveTardis(this.tempTardisData);
            }
            this.isRemat = false;
            this.isDemat = false;
            this.pulses = -1;
            this.dematAmount = 1.0f;
        }
    }

    public ChameleonCircuitBase getSkin(TardisData data) {
        return DMTardis.getTardisSkin(data.getExteriorID());
    }

    public void setDemat(boolean isDemat) {
        this.isDemat = isDemat;
        if (this.tempTardisData != null && this.tempTardisData.isDoorOpen()) {
            PacketHandler.INSTANCE.sendToDimension((IMessage)new Packet_TardisDoors(this.field_174879_c, false), this.func_145831_w().field_73011_w.getDimension());
            this.tempTardisData.setDoorOpen(false);
        }
    }

    public void transferPlayerToInterior(EntityLivingBase placer, BlockPos pos, float facing) {
        if (!placer.func_184207_aI()) {
            TeleportUtils.teleportToDimension((EntityPlayerMP)placer, DMDimensions.DIM_TARDIS_ID, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), facing, 0.0f);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 2), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 2), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 5), (double)(this.field_174879_c.func_177952_p() + 2));
    }

    public void setRemat(boolean isRemat) {
        this.isRemat = isRemat;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.func_145843_s();
        DMTardis.removeTardis(this.tardisID);
    }
}

