/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.network.packets;

import com.swdteam.client.init.DMSkinpacks;
import com.swdteam.network.packets.AbstractTwoWayMessageHandler;
import com.swdteam.network.packets.PacketHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Packet_SendSkinpackData
implements IMessage {
    public String playerFrom;
    public int packID;
    public int skinID;

    public Packet_SendSkinpackData() {
    }

    public Packet_SendSkinpackData(String playerFrom, int pack, int skin) {
        this.playerFrom = playerFrom;
        this.packID = pack;
        this.skinID = skin;
    }

    public void fromBytes(ByteBuf buf) {
        this.playerFrom = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.packID = buf.readInt();
        this.skinID = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerFrom);
        buf.writeInt(this.packID);
        buf.writeInt(this.skinID);
    }

    public static class Handler
    extends AbstractTwoWayMessageHandler<Packet_SendSkinpackData> {
        @Override
        @SideOnly(value=Side.CLIENT)
        public IMessage handleClientMessage(EntityPlayer player, Packet_SendSkinpackData message, MessageContext ctx) {
            DMSkinpacks.addSession(message.playerFrom, message.packID, message.skinID);
            return null;
        }

        @Override
        public IMessage handleServerMessage(EntityPlayer player, Packet_SendSkinpackData message, MessageContext ctx) {
            PacketHandler.INSTANCE.sendToAll((IMessage)new Packet_SendSkinpackData(message.playerFrom, message.packID, message.skinID));
            return null;
        }
    }
}

