/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.entity;

import com.swdteam.common.block.BlockTardis;
import com.swdteam.common.entity.EntityTimelord;
import com.swdteam.common.entity.IEventListener;
import com.swdteam.common.entity.ai.AngelAttackMelee;
import com.swdteam.common.init.DMDamageSources;
import com.swdteam.common.init.DMDimensions;
import com.swdteam.common.init.DMItems;
import com.swdteam.common.init.DMSounds;
import com.swdteam.main.config.DMConfig;
import com.swdteam.utils.DMUtils;
import com.swdteam.utils.PlayerUtils;
import com.swdteam.utils.WorldUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

@Mod.EventBusSubscriber(modid="thedalekmod")
public class EntityWeepingAngel
extends EntityMob
implements IEntityAdditionalSpawnData,
IEventListener {
    private ItemStack stolenKey;
    private static final DataParameter<Boolean> IS_ANGRY = EntityDataManager.func_187226_a(EntityWeepingAngel.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_BREAKING_BLOCKS = EntityDataManager.func_187226_a(EntityWeepingAngel.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<ItemStack> CARRIED_ITEM = EntityDataManager.func_187226_a(EntityWeepingAngel.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Boolean> CAN_BE_SEEN = EntityDataManager.func_187226_a(EntityWeepingAngel.class, (DataSerializer)DataSerializers.field_187198_h);
    private int block_break_time = 0;
    private int time_seen = 0;

    public EntityWeepingAngel(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.95f);
        float moveSpeed = 0.2f;
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AngelAttackMelee((EntityCreature)this, moveSpeed, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITempt((EntityCreature)this, 9.5, DMItems.TARDIS_KEY, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityTimelord.class, true));
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(CARRIED_ITEM, (Object)new ItemStack(Items.field_190931_a, 1, 0));
        this.func_184212_Q().func_187214_a(IS_BREAKING_BLOCKS, (Object)false);
        this.func_184212_Q().func_187214_a(IS_ANGRY, (Object)false);
        this.func_184212_Q().func_187214_a(CAN_BE_SEEN, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(150.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1000.0);
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150348_b), this.func_70681_au().nextInt(3));
        if (this.getStolenKey() != null) {
            this.func_70099_a(this.getStolenKey(), 0.0f);
        }
        super.func_70628_a(wasRecentlyHit, lootingModifier);
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (!this.isBeingViewed() || !this.field_70122_E) {
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    protected void func_70664_aZ() {
        if (!this.isBeingViewed()) {
            super.func_70664_aZ();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.time_seen;
        if (this.time_seen > 15) {
            this.setBeingSeen(false);
            this.time_seen = 0;
        }
        if (this.isBlockBreaking()) {
            ++this.block_break_time;
            if (this.block_break_time == 15) {
                this.setBreakingBlock(false);
                this.block_break_time = 0;
            }
        }
        if (this.isBeingViewed() && !this.isBlockBreaking() && this.func_70638_az() != null && this.field_70170_p.field_73012_v.nextInt(10) == 5) {
            this.func_184212_Q().func_187227_b(IS_ANGRY, (Object)this.field_70146_Z.nextBoolean());
        }
        if (this.isBeingViewed()) {
            if (!this.field_70170_p.field_72995_K && DMConfig.mobs.Angel_Light && this.field_70170_p.field_73012_v.nextInt(400) == 200) {
                List<WorldUtils.BlockWithPos> blocks = WorldUtils.getBlocksWithinBounds(this.field_70170_p, this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
                for (WorldUtils.BlockWithPos block : blocks) {
                    if (block.getBlock() == null || block.getBlock().getRegistryName().toString().contains("biomesoplenty:")) continue;
                    if (block.getBlock() == Blocks.field_150374_bv) {
                        this.block_break_time = 0;
                        this.setAngry(false);
                        this.setBreakingBlock(true);
                        this.func_184185_a(DMSounds.angelBreakLight, 1.0f, 1.0f);
                        DMUtils.setBlock(this.field_70170_p, block.getBlockPos().func_177958_n(), block.getBlockPos().func_177956_o(), block.getBlockPos().func_177952_p(), Blocks.field_150379_bu);
                    }
                    if (block.getBlock() == Blocks.field_150478_aa) {
                        this.block_break_time = 0;
                        this.setAngry(false);
                        this.setBreakingBlock(true);
                        this.func_184185_a(DMSounds.angelBreakLight, 1.0f, 1.0f);
                        DMUtils.setBlock(this.field_70170_p, block.getBlockPos().func_177958_n(), block.getBlockPos().func_177956_o(), block.getBlockPos().func_177952_p(), Blocks.field_150437_az);
                    }
                    if (block.getBlock() == Blocks.field_150429_aA) {
                        this.block_break_time = 0;
                        this.setAngry(false);
                        this.setBreakingBlock(true);
                        this.func_184185_a(DMSounds.angelBreakLight, 1.0f, 1.0f);
                        DMUtils.setBlock(this.field_70170_p, block.getBlockPos().func_177958_n(), block.getBlockPos().func_177956_o(), block.getBlockPos().func_177952_p(), Blocks.field_150437_az);
                    }
                    if (block.getBlock().func_149750_m(block.getBlock().func_176223_P()) < 7 || block.getBlock() instanceof BlockTardis) continue;
                    this.block_break_time = 0;
                    this.setAngry(false);
                    this.setBreakingBlock(true);
                    this.func_184185_a(DMSounds.angelBreakLight, 1.0f, 1.0f);
                    DMUtils.setBlock(this.field_70170_p, block.getBlockPos().func_177958_n(), block.getBlockPos().func_177956_o(), block.getBlockPos().func_177952_p(), Blocks.field_150350_a);
                    this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, (double)block.getBlockPos().func_177958_n(), (double)block.getBlockPos().func_177956_o(), (double)block.getBlockPos().func_177952_p(), new ItemStack(block.getBlock(), 1, 0)));
                    break;
                }
            }
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)2.2f);
        }
    }

    public void setAngry(boolean angry) {
        this.func_184212_Q().func_187227_b(IS_ANGRY, (Object)angry);
    }

    public void setBreakingBlock(boolean breaking) {
        this.func_184212_Q().func_187227_b(IS_BREAKING_BLOCKS, (Object)breaking);
    }

    public void setBeingSeen(boolean canbeseen) {
        this.func_184212_Q().func_187227_b(CAN_BE_SEEN, (Object)canbeseen);
    }

    public boolean isAngry() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_ANGRY);
    }

    public boolean isBlockBreaking() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_BREAKING_BLOCKS);
    }

    public boolean isBeingViewed() {
        return (Boolean)this.func_184212_Q().func_187225_a(CAN_BE_SEEN);
    }

    protected boolean func_70610_aX() {
        return this.isBeingViewed();
    }

    public List<EntityPlayer> getPlayers() {
        return this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(50.0, 50.0, 50.0));
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    protected void func_82167_n(Entity e) {
        if (!this.field_70170_p.field_72995_K) {
            boolean teleport = DMConfig.mobs.Angel_Teleport;
            if (this.field_70170_p.field_73012_v.nextBoolean() && teleport && e.func_130014_f_().field_73011_w.getDimension() != DMDimensions.DIM_TARDIS_ID) {
                double x = this.field_70165_t + (double)this.field_70146_Z.nextInt(120);
                double y = this.field_70163_u + (double)this.field_70146_Z.nextInt(64);
                double z = this.field_70161_v + (double)this.field_70146_Z.nextInt(120);
                BlockPos p = new BlockPos(x, y, z);
                e.field_70170_p.func_184148_a(null, e.field_70165_t, e.field_70163_u, e.field_70161_v, DMSounds.angelwoosh, SoundCategory.PLAYERS, 1.0f, 1.0f);
                e.func_70634_a(x, y, z);
                for (Object players : this.field_70170_p.field_73010_i) {
                    EntityPlayer dp = (EntityPlayer)players;
                    if (dp.field_71071_by.func_70431_c(new ItemStack(DMItems.timeyWimey))) {
                        PlayerUtils.Messaging.sendMessageToPlayer(dp, TextFormatting.YELLOW + "Temporal Anomaly detected at: " + TextFormatting.BLUE + p.func_177958_n() + ", " + p.func_177956_o() + ", " + p.func_177952_p());
                        dp.field_70170_p.func_184148_a(null, dp.field_70165_t, dp.field_70163_u, dp.field_70161_v, DMSounds.ding, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    }
                    for (Object chicken : dp.field_70170_p.func_72872_a(EntityChicken.class, dp.func_174813_aQ().func_72314_b(30.0, 30.0, 30.0))) {
                        if (!(chicken instanceof EntityChicken) || !dp.field_70170_p.field_73012_v.nextBoolean()) continue;
                        EntityChicken chick = (EntityChicken)chicken;
                        chick.func_130014_f_().func_72876_a((Entity)chick, (double)chick.func_180425_c().func_177958_n(), (double)chick.func_180425_c().func_177956_o(), (double)chick.func_180425_c().func_177952_p(), 0.5f, false);
                        chick.func_70106_y();
                    }
                }
            }
        }
        super.func_82167_n(e);
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        super.func_70665_d(DMDamageSources.WEEPINGANGEL, damageAmount);
    }

    public ItemStack getStolenKey() {
        return (ItemStack)this.func_184212_Q().func_187225_a(CARRIED_ITEM);
    }

    public boolean func_70652_k(Entity entity) {
        if (this.isBeingViewed()) {
            return false;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            player.func_70097_a(DMDamageSources.WEEPINGANGEL, 4.0f);
            if (this.getStolenKey() != null && this.getStolenKey().func_77973_b() != DMItems.TARDIS_KEY && this.field_70146_Z.nextBoolean()) {
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack stack = player.field_71071_by.func_70301_a(i);
                    if (stack.func_77973_b() == Items.field_190931_a || stack.func_77973_b() != DMItems.TARDIS_KEY) continue;
                    this.stolenKey = player.field_71071_by.func_70301_a(i).func_77946_l();
                    player.field_71071_by.func_70301_a(i).func_190920_e(0);
                    player.field_71069_bz.func_75142_b();
                    if (this.field_70170_p.field_72995_K) continue;
                    player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "message.angel.key_taken", new Object[0]));
                    this.func_184212_Q().func_187227_b(CARRIED_ITEM, (Object)this.stolenKey);
                }
            }
            if (this.field_70146_Z.nextInt(3) == 2) {
                player.func_70097_a(DMDamageSources.WEEPINGANGEL, 1.0f);
                if (player.func_70660_b(MobEffects.field_76440_q) == null) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 50, 5));
                }
                if (player.func_70660_b(MobEffects.field_76421_d) == null) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 18, 5));
                }
                if (player.func_70660_b(MobEffects.field_76437_t) == null) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 18, 5));
                }
                if (player.func_70660_b(MobEffects.field_76431_k) == null) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 18, 5));
                }
            }
        }
        return super.func_70652_k(entity);
    }

    public void func_70014_b(NBTTagCompound nbt_tag) {
        super.func_70014_b(nbt_tag);
        if (this.getStolenKey() != null && this.getStolenKey().func_77973_b() == DMItems.TARDIS_KEY) {
            NBTTagCompound tag = new NBTTagCompound();
            this.getStolenKey().func_77955_b(tag);
            nbt_tag.func_74782_a("items", (NBTBase)tag);
        }
    }

    public void func_70037_a(NBTTagCompound nbt_tag) {
        super.func_70037_a(nbt_tag);
        NBTTagCompound tag = nbt_tag.func_74775_l("items");
        this.stolenKey = new ItemStack(tag);
        this.func_184212_Q().func_187227_b(CARRIED_ITEM, (Object)this.stolenKey);
    }

    private boolean teleportTo(double X, double Y, double Z) {
        BlockPos p = new BlockPos(X, Y, Z);
        if (this.field_70170_p.func_175623_d(p)) {
            if (this.field_70170_p.func_180495_p(p.func_177982_a(0, -1, 0)).func_185904_a().func_76220_a()) {
                this.func_70634_a(p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
            } else {
                for (int i = 1; i < 255; ++i) {
                    if (!this.field_70170_p.func_180495_p(p.func_177982_a(0, -p.func_177956_o() + i - 1, 0)).func_185904_a().func_76220_a()) continue;
                    this.func_70634_a(p.func_177958_n(), i, p.func_177952_p());
                }
            }
        } else {
            for (int i = 1; i < 255; ++i) {
                if (!this.field_70170_p.func_175623_d(p.func_177982_a(0, -p.func_177956_o() + i, 0)) || !this.field_70170_p.func_180495_p(p.func_177982_a(0, -p.func_177956_o() + i - 1, 0)).func_185904_a().func_76220_a()) continue;
                this.func_70634_a(p.func_177958_n(), i, p.func_177952_p());
            }
        }
        return true;
    }

    public void writeSpawnData(ByteBuf buffer) {
        if (this.getStolenKey() != null) {
            ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.getStolenKey());
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        try {
            this.stolenKey = ByteBufUtils.readItemStack((ByteBuf)additionalData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void attacked(LivingHurtEvent e) {
        if (e.getSource().func_76346_g() instanceof Entity) {
            EntityLivingBase attacker = (EntityLivingBase)e.getSource().func_76346_g();
            EntityLivingBase victim = e.getEntityLiving();
            float damage = e.getAmount();
            if (victim instanceof EntityWeepingAngel) {
                Item item = attacker.func_184586_b(EnumHand.MAIN_HAND).func_77973_b();
                if (item instanceof ItemPickaxe || item == DMItems.iBrassPickaxe || item == DMItems.dalekaniumBattleAxe) {
                    victim.func_70097_a(DamageSource.field_76377_j, damage + (float)DMUtils.RANDOM.nextInt(5));
                } else {
                    e.setCanceled(true);
                    victim.func_70097_a(DamageSource.field_76377_j, 0.5f);
                    attacker.func_70097_a(DMDamageSources.WEEPINGANGEL_STONE, 2.0f);
                }
            }
        }
    }
}

