/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.init;

import com.swdteam.main.TheDalekMod;
import com.swdteam.utils.IOUtils;
import com.swdteam.utils.model.AdvancedModelLoader;
import com.swdteam.utils.model.IModelCustom;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;

public class DMHatModels {
    public static HashMap<Integer, HatModelData> hats = new HashMap();
    public static String[] hats_list = new String[0];

    public static void init() {
        String s;
        File f = new File(Minecraft.func_71410_x().field_71412_D.getAbsolutePath() + "/mods/Dalek Mod/data/hmd/");
        if (!f.exists()) {
            f.mkdirs();
        }
        if ((s = IOUtils.getJsonFromURL("http://api.swdteam.com/dm/items/hats/getHatList.json")) != null) {
            hats_list = (String[])TheDalekMod.GSON.fromJson(s, String[].class);
        }
        for (String string : hats_list) {
        }
    }

    public static void checkAndLoadHat(String s) throws Exception {
        File f = new File(Minecraft.func_71410_x().field_71412_D.getAbsolutePath() + "/mods/Dalek Mod/data/hmd/" + s + ".hmd");
        if (!f.exists()) {
            IOUtils.tryDownloadFile("http://api.swdteam.com/dm/items/hats/files/" + s + ".hmd", f.getAbsolutePath());
        } else {
            long size = IOUtils.getFileSizeURL(new URL("http://api.swdteam.com/dm/items/hats/files/" + s + ".hmd"));
            if (f.length() != size) {
                IOUtils.tryDownloadFile("http://api.swdteam.com/dm/items/hats/files/" + s + ".hmd", f.getAbsolutePath());
                System.out.println("Change found for model: " + s);
            }
        }
        ZipFile zipFile = new ZipFile(f);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        HatModelData hmd = null;
        BufferedImage image = null;
        IModelCustom model = null;
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            InputStream stream = zipFile.getInputStream(entry);
            if (entry.getName().equals("info.json")) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                reader.close();
                hmd = (HatModelData)TheDalekMod.GSON.fromJson(sb.toString(), HatModelData.class);
            }
            if (entry.getName().equals("tex.png")) {
                image = ImageIO.read(stream);
            }
            if (entry.getName().equals("z_model.obj")) {
                try {
                    model = AdvancedModelLoader.loadModel(stream, entry.getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            stream.close();
        }
        zipFile.close();
        if (hmd != null) {
            hmd.hatModel = model;
            hmd.hatTex = image;
        }
        hats.put(hmd.hat_id, hmd);
    }

    public static HatModelData getHatData(int i) {
        if (!hats.containsKey(i)) {
            DMHatModels.loadHat(i);
            hats.put(i, null);
        }
        return hats.get(i);
    }

    private static void loadHat(int i) {
        new Thread(() -> {
            String s = IOUtils.getJsonFromURL("http://api.swdteam.com/dm/items/hats/getHatList.json");
            if (s != null) {
                hats_list = (String[])TheDalekMod.GSON.fromJson(s, String[].class);
            }
            if (i < hats_list.length) {
                try {
                    DMHatModels.checkAndLoadHat(hats_list[i]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public static class HatModelData {
        public int hat_id;
        public String hat_name;
        public BufferedImage hatTex;
        public IModelCustom hatModel;
        public int hatTexID = -1;
    }
}

