/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.gui;

import com.swdteam.client.gui.elements.GuiColorButton;
import com.swdteam.common.tileentity.tardis.decoration.TileEntityChalkboard;
import com.swdteam.main.TheDalekMod;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_UpdateChalkboard;
import com.swdteam.utils.DMUtils;
import com.swdteam.utils.FileUtils;
import com.swdteam.utils.Graphics;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class GuiChalkboard
extends GuiScreen {
    BoardState state = BoardState.DRAWING_MODE;
    public static final ResourceLocation CHALKBOARD = FileUtils.newResourceLocation("thedalekmod:gui/chalkboard.png");
    private int currentColor;
    private TileEntityChalkboard te;
    private int[][] pixels;
    boolean edit;
    GuiButton blobBack;
    GuiButton blobApply;
    GuiButton blobCopy;
    String blobTextHeader;
    private GuiTextField blobTextarea;
    List<Point> points = new ArrayList<Point>();

    public GuiChalkboard(TileEntityChalkboard te) {
        this.te = te;
        this.pixels = new int[32][18];
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 18; ++j) {
                this.pixels[i][j] = te.getPixel(i, j);
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        int scale = 10;
        int height = 18 * scale;
        int yPos = this.field_146295_m / 2 - height / 2 - 8;
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 + 88, yPos + height + 10, 80, 20, "Done"));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 3, yPos + height + 10, 80, 20, "Clear"));
        this.field_146292_n.add(new GuiButton(2, this.field_146294_l / 2 - 82, yPos + height + 10, 80, 20, "Cancel"));
        this.field_146292_n.add(new GuiButton(4, this.field_146294_l / 2 - 167, yPos + height + 10, 80, 20, "Blob"));
        this.field_146292_n.add(new GuiColorButton(3, this.field_146294_l / 2 - 192, this.field_146295_m / 2 - 110, -16777216));
        this.field_146292_n.add(new GuiColorButton(3, this.field_146294_l / 2 - 192, this.field_146295_m / 2 - 86, -16777046));
        this.field_146292_n.add(new GuiColorButton(3, this.field_146294_l / 2 - 192, this.field_146295_m / 2 - 62, -16733696));
        this.field_146292_n.add(new GuiColorButton(3, this.field_146294_l / 2 - 192, this.field_146295_m / 2 - 38, -16733526));
        this.field_146292_n.add(new GuiColorButton(3, this.field_146294_l / 2 - 192, this.field_146295_m / 2 - 14, -5636096));
        this.field_146292_n.add(new GuiColorButton(3, this.field_146294_l / 2 - 192, this.field_146295_m / 2 + 10, -5635926));
        this.field_146292_n.add(new GuiColorButton(3, this.field_146294_l / 2 - 192, this.field_146295_m / 2 + 34, -22016));
        this.field_146292_n.add(new GuiColorButton(3, this.field_146294_l / 2 - 192, this.field_146295_m / 2 + 58, -5592406));
        this.field_146292_n.add(new GuiColorButton(3, this.field_146294_l / 2 + 172, this.field_146295_m / 2 - 110, -11184811));
        this.field_146292_n.add(new GuiColorButton(3, this.field_146294_l / 2 + 172, this.field_146295_m / 2 - 86, -11184641));
        this.field_146292_n.add(new GuiColorButton(3, this.field_146294_l / 2 + 172, this.field_146295_m / 2 - 62, -11141291));
        this.field_146292_n.add(new GuiColorButton(3, this.field_146294_l / 2 + 172, this.field_146295_m / 2 - 38, -11141121));
        this.field_146292_n.add(new GuiColorButton(3, this.field_146294_l / 2 + 172, this.field_146295_m / 2 - 14, -43691));
        this.field_146292_n.add(new GuiColorButton(3, this.field_146294_l / 2 + 172, this.field_146295_m / 2 + 10, -43521));
        this.field_146292_n.add(new GuiColorButton(3, this.field_146294_l / 2 + 172, this.field_146295_m / 2 + 34, -171));
        this.field_146292_n.add(new GuiColorButton(3, this.field_146294_l / 2 + 172, this.field_146295_m / 2 + 58, -1));
        this.blobTextarea = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 120, this.field_146295_m / 2 - 48, 240, 20);
        this.blobTextarea.func_146203_f(9000000);
        this.blobBack = new GuiButton(5, this.field_146294_l / 2 - 122, this.field_146295_m / 2 - 22, 78, 20, "Back");
        this.blobCopy = new GuiButton(6, this.field_146294_l / 2 - 39, this.field_146295_m / 2 - 22, 78, 20, "Copy");
        this.blobApply = new GuiButton(7, this.field_146294_l / 2 + 44, this.field_146295_m / 2 - 22, 78, 20, "Apply");
        this.field_146292_n.add(this.blobBack);
        this.field_146292_n.add(this.blobCopy);
        this.field_146292_n.add(this.blobApply);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 0: {
                BlockPos pos = this.te.func_174877_v();
                PacketHandler.INSTANCE.sendToServer((IMessage)new Packet_UpdateChalkboard(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), DMUtils.to1dArray(this.pixels, 32, 18)));
                this.field_146297_k.func_147108_a(null);
                break;
            }
            case 1: {
                this.pixels = new int[32][18];
                break;
            }
            case 2: {
                this.field_146297_k.func_147108_a(null);
                break;
            }
            case 3: {
                if (!(button instanceof GuiColorButton)) break;
                this.currentColor = ((GuiColorButton)button).getColor();
                break;
            }
            case 4: {
                this.state = BoardState.BLOB_INPUT;
                try {
                    this.blobTextarea.func_146180_a(DMUtils.blobifyObject(this.pixels));
                }
                catch (Exception e) {
                    TheDalekMod.LOG.catching((Throwable)e);
                }
                break;
            }
            case 5: {
                this.state = BoardState.DRAWING_MODE;
                this.blobTextHeader = "Chalkboard Blob String";
                this.edit = false;
                break;
            }
            case 6: {
                this.blobTextHeader = "Chalkboard Blob copied to clipboard";
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.blobTextarea.func_146179_b()), null);
                break;
            }
            case 7: {
                try {
                    int[][] pix = (int[][])DMUtils.deblobifyString(this.blobTextarea.func_146179_b());
                    if (pix != null) {
                        this.pixels = pix;
                    }
                    this.blobTextHeader = "Chalkboard Blob applied";
                }
                catch (Exception e) {
                    this.blobTextHeader = "Not a valid blob";
                }
                break;
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (this.state == BoardState.BLOB_INPUT) {
            this.blobTextarea.func_146201_a(typedChar, keyCode);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int scale = 10;
        int width = 32 * scale;
        int height = 18 * scale;
        int xPos = this.field_146294_l / 2 - width / 2;
        int yPos = this.field_146295_m / 2 - height / 2 - 16;
        Graphics.FillRect((double)(xPos - 6), (double)(yPos - 6), (double)(width + 12), (double)(height + 12), 0.0, -10083840);
        Graphics.draw(CHALKBOARD, xPos, yPos, width, height, 0);
        if (this.te != null) {
            for (int x = 0; x < 32; ++x) {
                for (int y = 0; y < 18; ++y) {
                    if (this.pixels[x][y] == 0) continue;
                    Graphics.FillRect((double)(xPos + x * 10), (double)(yPos + y * 10), (double)scale, (double)scale, 0.0, this.pixels[x][y]);
                }
            }
        }
        if (this.state == BoardState.DRAWING_MODE && DMUtils.isMouseInBounds(mouseX, mouseY, new Rectangle(xPos, yPos, width, height))) {
            this.performDrawing(xPos, yPos, mouseX, mouseY, scale);
        }
        if (this.state == BoardState.BLOB_INPUT) {
            Graphics.FillRect(0.0, 0.0, (double)this.field_146294_l, (double)this.field_146295_m, 0.0, -872415232);
            this.blobTextarea.func_146194_f();
            this.blobBack.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
            this.blobCopy.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
            this.blobApply.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
            this.func_73732_a(this.field_146289_q, this.blobTextHeader, this.field_146294_l / 2, this.field_146295_m / 2 - 64, -1);
        }
    }

    private void performDrawing(float xPos, float yPos, int mouseX, int mouseY, float scale) {
        Graphics.FillRect((double)((float)mouseX - scale / 2.0f - 1.0f), (double)((float)mouseY - scale / 2.0f - 1.0f), (double)(scale + 2.0f), (double)(scale + 2.0f), 0.0, -16777216);
        Graphics.FillRect((double)((float)mouseX - scale / 2.0f), (double)((float)mouseY - scale / 2.0f), (double)scale, (double)scale, 0.0, this.currentColor);
        int x = (int)(((float)mouseX - xPos) / 10.0f);
        int y = (int)(((float)mouseY - yPos) / 10.0f);
        if (Mouse.isButtonDown((int)0) && this.te != null) {
            Point p;
            if (this.edit && !this.points.contains(p = new Point(x, y))) {
                this.points.add(p);
                if (x < 32 && y < 18) {
                    Color c1 = new Color(this.pixels[x][y], true);
                    Color c2 = new Color(this.currentColor - -1442840576, true);
                    Color blend = GuiChalkboard.blend(c1, c2);
                    this.pixels[x][y] = blend.getRGB();
                }
            }
        } else {
            this.points.clear();
            this.edit = true;
        }
        if (Mouse.isButtonDown((int)1) && this.te != null && x < 32 && y < 18) {
            this.pixels[x][y] = 0;
        }
    }

    public static Color blend(Color c0, Color c1) {
        int totalAlpha = c0.getAlpha() + c1.getAlpha();
        int weight0 = c0.getAlpha() / totalAlpha;
        int weight1 = c1.getAlpha() / totalAlpha;
        int r = weight0 * c0.getRed() + weight1 * c1.getRed();
        int g = weight0 * c0.getGreen() + weight1 * c1.getGreen();
        int b = weight0 * c0.getBlue() + weight1 * c1.getBlue();
        int a = totalAlpha > 255 ? 255 : totalAlpha;
        return new Color(r, g, b, a);
    }

    public void func_73876_c() {
        for (GuiButton button : this.field_146292_n) {
            button.field_146124_l = button.field_146127_k != 5 && button.field_146127_k != 6 && button.field_146127_k != 7;
        }
        if (this.state == BoardState.BLOB_INPUT) {
            this.blobTextarea.func_146178_a();
        }
        super.func_73876_c();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.blobTextarea.func_146192_a(mouseX, mouseY, mouseButton);
    }

    public boolean func_73868_f() {
        return false;
    }

    public static enum BoardState {
        BLOB_INPUT,
        DRAWING_MODE;

    }
}

