/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.particle.Particle;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;

public abstract class ParticleHandler {
    public static Map<ResourceLocation, ICustomParticleFactory> factories = new HashMap<ResourceLocation, ICustomParticleFactory>();

    public static void registerParticle(ResourceLocation id, ICustomParticleFactory factory) {
        Validate.notNull((Object)factory);
        if (factories.put(id, factory) != null) {
            throw new IllegalArgumentException("Particle with id " + id + " is already registered");
        }
    }

    public abstract void spawnParticle(World var1, ResourceLocation var2, double var3, double var5, double var7, Object ... var9);

    public void spawnParticle(World world, ResourceLocation particle, double posX, double posY, double posZ, NBTTagCompound nbt) {
    }

    public abstract void spawnParticles(World var1, ResourceLocation var2, double var3, double var5, double var7, int var9, double var10, Random var12, Object ... var13);

    public void spawnParticles(World world, ResourceLocation particle, double posX, double posY, double posZ, int count, double maxDist, Random random, NBTTagCompound nbt) {
    }

    public static interface ICustomParticleFactory {
        @SideOnly(value=Side.CLIENT)
        public Particle createParticle(World var1, double var2, double var4, double var6, Object ... var8);

        @Nonnull
        public NBTTagCompound createParticleInfo(Object ... var1);

        @SideOnly(value=Side.CLIENT)
        @Nullable
        public Object[] readParticleInfo(NBTTagCompound var1);
    }
}

