/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.entity.dalek;

import com.swdteam.client.resources.IResourceLoader;
import com.swdteam.common.entity.EntityLaser;
import com.swdteam.common.entity.dalek.EntityDalek;
import com.swdteam.common.entity.dalek.IDalek;
import com.swdteam.common.init.DMDamageSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class DalekBase
implements IDalek,
IResourceLoader {
    public SoundEvent[] attackSounds = new SoundEvent[0];
    public SoundEvent[] shootSounds = new SoundEvent[0];
    public SoundEvent[] attackedSounds = new SoundEvent[0];
    public SoundEvent[] spawnSounds = new SoundEvent[0];
    public SoundEvent[] deathSounds = new SoundEvent[0];
    public SoundEvent[] livingSounds = new SoundEvent[0];
    public SoundEvent[] hurtSounds = new SoundEvent[0];
    private ResourceLocation TEXTURE;

    @Override
    public void setupDalek(Entity e) {
        if (e.field_70170_p.field_73012_v.nextInt(5) == 3) {
            this.playSound((EntityDalek)e, this.getSpawnSound(e));
        }
    }

    @Override
    public void initAI(EntityAITasks e) {
    }

    @Override
    public void onUpdate(Entity e) {
    }

    @Override
    public void onDeath(Entity e) {
    }

    @Override
    public void onAttacked(Entity dalek, Entity attacker, DamageSource damage) {
        if (dalek.field_70170_p.field_73012_v.nextInt(5) == 3) {
            this.playSound((EntityDalek)dalek, this.getAttackedSound(dalek));
        }
    }

    @Override
    public void onLaserAttack(EntityDalek dalek, EntityLivingBase living, float par2) {
        if (living.field_70128_L) {
            return;
        }
        dalek.func_70625_a((Entity)living, 1.0f, 1.0f);
        if (dalek.field_70170_p.field_73012_v.nextInt(5) == 2) {
            dalek.func_184185_a(this.getAttackSound((Entity)dalek), 1.0f, 1.0f);
        }
        EntityLaser entityarrow = new EntityLaser(dalek.field_70170_p, (EntityLivingBase)dalek);
        entityarrow.setDamageSource(DMDamageSource.EXTERMINATED);
        entityarrow.setDamage(9.0f);
        double d0 = living.field_70165_t - dalek.field_70165_t;
        double d1 = living.func_174813_aQ().field_72338_b + (double)(living.field_70131_O / 3.0f) - entityarrow.field_70163_u;
        double d2 = living.field_70161_v - dalek.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - dalek.field_70170_p.func_175659_aa().func_151525_a() * 4);
        dalek.func_184185_a(this.getShootSound((Entity)dalek), 1.0f, 1.0f);
        dalek.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    @Override
    public String getName() {
        return "1963 Skaro Dalek";
    }

    @Override
    public ResourceLocation getTexture() {
        return this.TEXTURE;
    }

    public static SoundEvent getRandomSound(Entity e, SoundEvent[] s) {
        if (e != null && s != null && s.length != 0) {
            return s[e.field_70170_p.field_73012_v.nextInt(s.length)];
        }
        return null;
    }

    @Override
    public SoundEvent getHurtSound(Entity e) {
        return DalekBase.getRandomSound(e, this.hurtSounds);
    }

    @Override
    public SoundEvent getLivingSound(Entity e) {
        return DalekBase.getRandomSound(e, this.livingSounds);
    }

    @Override
    public SoundEvent getDeathSound(Entity e) {
        return DalekBase.getRandomSound(e, this.deathSounds);
    }

    @Override
    public SoundEvent getSpawnSound(Entity e) {
        return DalekBase.getRandomSound(e, this.spawnSounds);
    }

    @Override
    public SoundEvent getAttackSound(Entity e) {
        return DalekBase.getRandomSound(e, this.attackSounds);
    }

    @Override
    public SoundEvent getAttackedSound(Entity e) {
        return DalekBase.getRandomSound(e, this.attackedSounds);
    }

    @Override
    public SoundEvent getShootSound(Entity e) {
        return DalekBase.getRandomSound(e, this.shootSounds);
    }

    public void setAttackedSounds(SoundEvent[] attackedSounds) {
        this.attackedSounds = attackedSounds;
    }

    public void setAttackSounds(SoundEvent[] attackSounds) {
        this.attackSounds = attackSounds;
    }

    public void setDeathSounds(SoundEvent[] deathSounds) {
        this.deathSounds = deathSounds;
    }

    public void setHurtSounds(SoundEvent[] hurtSounds) {
        this.hurtSounds = hurtSounds;
    }

    public void setLivingSounds(SoundEvent[] livingSounds) {
        this.livingSounds = livingSounds;
    }

    public void setShootSounds(SoundEvent[] shootSounds) {
        this.shootSounds = shootSounds;
    }

    public void setSpawnSounds(SoundEvent[] spawnSounds) {
        this.spawnSounds = spawnSounds;
    }

    public void playSound(EntityDalek w, SoundEvent s) {
        if (s != null) {
            w.func_184185_a(s, 1.0f, 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setTexture(ResourceLocation tEXTURE) {
        this.TEXTURE = tEXTURE;
    }

    @Override
    public boolean shouldReload() {
        return true;
    }
}

