/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.api.main;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.swdteam.api.main.Credentials;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;

public class Utils {
    public static Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static String getHTTPResponse(String url, String ... args) throws Exception {
        String inputLine;
        if (args.length == 0 || args.length % 2 != 0) {
            throw new Exception("Args cannot be odd. (VAR, VALUE)");
        }
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("User-Agent", "SWDTeam API");
        con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < args.length) {
            if (i == 0) {
                sb.append(String.valueOf(args[i]) + "=" + args[i + 1]);
            } else {
                sb.append("&" + args[i] + "=" + args[i + 1]);
            }
            i += 2;
        }
        String urlParameters = sb.toString();
        con.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(con.getOutputStream());
        wr.writeBytes(urlParameters);
        wr.flush();
        wr.close();
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        String ss = response.toString();
        ss = ss.substring(ss.indexOf("{"));
        ss = ss.substring(0, ss.lastIndexOf("}") + 1);
        return ss;
    }

    public static Map<String, String> decodeHashJson(String s) {
        Map map = (Map)GSON.fromJson(s, new TypeToken<Map<String, String>>(){}.getType());
        return map;
    }

    public static void log(Object o) {
        System.out.println("[SWDTeam API 3.0] " + o);
    }

    public static String md5(String input) throws NoSuchAlgorithmException {
        String result = input;
        if (input != null) {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(input.getBytes());
            BigInteger hash = new BigInteger(1, md.digest());
            result = hash.toString(16);
            while (result.length() < 32) {
                result = "0" + result;
            }
        }
        return result;
    }

    public static void saveCredentials(Credentials c) {
        String creds = Utils.encode(GSON.toJson((Object)c));
        File f = new File(String.valueOf(System.getProperty("user.home")) + "/.SWDTeam/data/auth/");
        if (!f.exists()) {
            f.mkdirs();
        }
        try {
            FileWriter writer = new FileWriter(String.valueOf(f.getAbsolutePath()) + "/auth.dat");
            writer.write(creds);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Credentials getCredentials() {
        File f = new File(String.valueOf(System.getProperty("user.home")) + "/.SWDTeam/data/auth/");
        if (!f.exists()) {
            f.mkdirs();
            return null;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(String.valueOf(f.getAbsolutePath()) + "/auth.dat"));
        }
        catch (FileNotFoundException e) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                b.append(line);
            }
            reader.close();
        }
        catch (IOException e) {
            return null;
        }
        Credentials creds = null;
        try {
            creds = (Credentials)GSON.fromJson(Utils.decode(b.toString()), Credentials.class);
        }
        catch (Exception e) {
            return null;
        }
        return creds;
    }

    private static String encode(String s) {
        return Base64.getEncoder().encodeToString(s.getBytes());
    }

    private static String decode(String s) {
        return new String(Base64.getDecoder().decode(s), StandardCharsets.UTF_8);
    }
}

