/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.entity.dalek;

import com.swdteam.client.resources.IResourceLoader;
import com.swdteam.common.entity.EntityLaser;
import com.swdteam.common.entity.dalek.EntityDalek;
import com.swdteam.common.entity.dalek.IDalek;
import com.swdteam.common.init.DMDamageSources;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class DalekBase
implements IDalek,
IResourceLoader {
    public SoundEvent[] attackSounds = new SoundEvent[0];
    public SoundEvent[] shootSounds = new SoundEvent[0];
    public SoundEvent[] attackedSounds = new SoundEvent[0];
    public SoundEvent[] spawnSounds = new SoundEvent[0];
    public SoundEvent[] deathSounds = new SoundEvent[0];
    public SoundEvent[] livingSounds = new SoundEvent[0];
    public SoundEvent[] hurtSounds = new SoundEvent[0];
    private ResourceLocation dalekTexture;

    @Override
    public void setupDalek(Entity e) {
        if (e.field_70170_p.field_73012_v.nextInt(5) == 3) {
            this.playSound((EntityDalek)e, this.getSpawnSound(e));
        }
    }

    @Override
    public void initAI(EntityAITasks e) {
    }

    @Override
    public void onUpdate(Entity e) {
    }

    @Override
    public void onDeath(Entity e) {
    }

    @Override
    public void onAttacked(Entity dalek, Entity attacker, DamageSource damage) {
        if (dalek.field_70170_p.field_73012_v.nextInt(5) == 3) {
            this.playSound((EntityDalek)dalek, this.getAttackedSound(dalek));
        }
    }

    @Override
    public void onLaserAttack(EntityDalek dalek, EntityLivingBase living, float par2) {
        if (living.field_70128_L) {
            return;
        }
        dalek.func_70625_a((Entity)living, 1.0f, 1.0f);
        if (dalek.field_70170_p.field_73012_v.nextInt(5) == 2) {
            dalek.func_184185_a(this.getAttackSound((Entity)dalek), 1.0f, 1.0f);
        }
        EntityLaser laser = new EntityLaser(dalek.field_70170_p, (EntityLivingBase)dalek, EnumParticleTypes.REDSTONE);
        laser.setDamageSource(DMDamageSources.EXTERMINATED);
        laser.setDamage(5.0f);
        Vec3d look = living.func_174791_d().func_178788_d(dalek.func_174791_d());
        laser.func_70107_b(dalek.field_70165_t + dalek.func_70040_Z().field_72450_a, dalek.field_70163_u + (double)dalek.func_70047_e(), dalek.field_70161_v + dalek.func_70040_Z().field_72449_c);
        laser.func_184538_a((Entity)dalek, dalek.field_70125_A, dalek.field_70759_as, 0.0f, 2.0f, 0.0f);
        laser.setLaser(dalek.getDalekData().getLaser());
        dalek.field_70170_p.func_72838_d((Entity)laser);
        dalek.func_184185_a(this.getShootSound((Entity)dalek), 1.0f, 1.0f);
    }

    @Override
    public String getName() {
        return "1963 Skaro Dalek";
    }

    @Override
    public ResourceLocation getTexture() {
        return this.dalekTexture;
    }

    public static SoundEvent getRandomSound(Entity e, SoundEvent[] s) {
        if (e != null && s != null && s.length != 0) {
            return s[e.field_70170_p.field_73012_v.nextInt(s.length)];
        }
        return null;
    }

    @Override
    public SoundEvent getHurtSound(Entity e) {
        return DalekBase.getRandomSound(e, this.hurtSounds);
    }

    @Override
    public SoundEvent getLivingSound(Entity e) {
        return DalekBase.getRandomSound(e, this.livingSounds);
    }

    @Override
    public SoundEvent getDeathSound(Entity e) {
        return DalekBase.getRandomSound(e, this.deathSounds);
    }

    @Override
    public SoundEvent getSpawnSound(Entity e) {
        return DalekBase.getRandomSound(e, this.spawnSounds);
    }

    @Override
    public SoundEvent getAttackSound(Entity e) {
        return DalekBase.getRandomSound(e, this.attackSounds);
    }

    @Override
    public SoundEvent getAttackedSound(Entity e) {
        return DalekBase.getRandomSound(e, this.attackedSounds);
    }

    @Override
    public SoundEvent getShootSound(Entity e) {
        return DalekBase.getRandomSound(e, this.shootSounds);
    }

    public void setAttackedSounds(SoundEvent[] attackedSounds) {
        this.attackedSounds = attackedSounds;
    }

    public void setAttackSounds(SoundEvent[] attackSounds) {
        this.attackSounds = attackSounds;
    }

    public void setDeathSounds(SoundEvent[] deathSounds) {
        this.deathSounds = deathSounds;
    }

    public void setHurtSounds(SoundEvent[] hurtSounds) {
        this.hurtSounds = hurtSounds;
    }

    public void setLivingSounds(SoundEvent[] livingSounds) {
        this.livingSounds = livingSounds;
    }

    public void setShootSounds(SoundEvent[] shootSounds) {
        this.shootSounds = shootSounds;
    }

    public void setSpawnSounds(SoundEvent[] spawnSounds) {
        this.spawnSounds = spawnSounds;
    }

    public void playSound(EntityDalek w, SoundEvent s) {
        if (s != null) {
            w.func_184185_a(s, 1.0f, 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setTexture(ResourceLocation tex) {
        this.dalekTexture = tex;
    }

    @Override
    public boolean shouldReload() {
        return true;
    }
}

