/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.init;

import com.swdteam.client.init.DMMDLLoader;
import com.swdteam.client.model.ModelCube;
import com.swdteam.utils.Graphics;
import com.swdteam.utils.model.techne.TechneModel;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;

public class DMTCNModelLoader {
    public static TechneModel defaultModel;
    public static int defaultTexture;
    static Random rand;
    static boolean defTex;
    private static HashMap<String, ModelBase> models;

    public static void initModels() {
        File folder;
        if (!defTex) {
            rand = new Random();
            BufferedImage im = new BufferedImage(64, 64, 10);
            for (int i = 0; i < 64; ++i) {
                for (int j = 0; j < 64; ++j) {
                    im.setRGB(i, j, 0);
                }
            }
            im.getGraphics().drawString("Missing", 11, 28);
            im.getGraphics().drawString("Model", 13, 41);
            defaultTexture = Graphics.loadTexture(im);
            defaultTexture = Graphics.loadTexture(im);
            defTex = true;
        }
        if (defaultModel == null) {
            defaultModel = new ModelCube();
        }
        if (!(folder = new File(Minecraft.func_71410_x().field_71412_D + "/mods/Dalek Mod/Models")).exists()) {
            folder.mkdirs();
        }
        File[] listOfFiles = folder.listFiles();
        for (int i = 0; i < listOfFiles.length; ++i) {
            FileInputStream is;
            if (!listOfFiles[i].isFile()) continue;
            if (listOfFiles[i].getName().endsWith(".tcn")) {
                is = null;
                try {
                    is = new FileInputStream(listOfFiles[i].getAbsolutePath());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                if (is != null && !models.containsKey(listOfFiles[i].getName())) {
                    DMTCNModelLoader.addModel(listOfFiles[i].getName(), new TechneModel(is));
                }
            }
            if (!listOfFiles[i].getName().endsWith(".mdl")) continue;
            is = null;
            try {
                is = new FileInputStream(listOfFiles[i].getAbsolutePath());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            if (is == null || models.containsKey(listOfFiles[i].getName())) continue;
            DMTCNModelLoader.addModel(listOfFiles[i].getName(), DMMDLLoader.loadModel(is, true));
        }
    }

    public static HashMap<String, ModelBase> getModels() {
        return models;
    }

    public static void addModel(String name, ModelBase b) {
        if (!models.containsKey(name)) {
            models.put(name, b);
        }
    }

    public static ModelBase getModel(String name) {
        if (models.containsKey(name)) {
            return models.get(name);
        }
        return defaultModel;
    }

    @Deprecated
    public static int loadTexture(BufferedImage image) {
        return Graphics.loadTexture(image);
    }

    static {
        models = new HashMap();
    }
}

