/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.world.gen;

import com.swdteam.common.entity.EntityAuton;
import com.swdteam.common.entity.EntityCyberman;
import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.world.gen.structures.WorldGenClassicTree;
import com.swdteam.main.config.DMConfig;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.common.IWorldGenerator;

public class DMOreGeneration
implements IWorldGenerator {
    WorldGenerator genTitaniumOre = new WorldGenMinable(DMBlocks.bTitaniumOre.func_176223_P(), 8);
    WorldGenerator genZeitonOre = new WorldGenMinable(DMBlocks.zeitonore.func_176223_P(), 17);
    WorldGenerator genSilicateOre = new WorldGenMinable(DMBlocks.silicate.func_176223_P(), 8);
    WorldGenerator genSonicCrystalOre = new WorldGenMinable(DMBlocks.SonicCrystalOre.func_176223_P(), 8);

    private void spawnDaleks(World world, Random rand, int chunkX, int chunkZ) {
        for (int i = 0; i < 5; ++i) {
            int randPosZ;
            int randPosX = chunkX + 8;
            int randPosY = rand.nextInt(96);
            BlockPos pos = new BlockPos(randPosX, randPosY, randPosZ = chunkZ + 8);
            if (world.func_175623_d(pos) || !world.func_175623_d(pos.func_177982_a(0, 1, 0))) continue;
            if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150391_bh) {
                return;
            }
            if (rand.nextInt(2) != 1 || world.field_73011_w.getDimension() == DMConfig.DimensionIDs.Skaro_Dimension_ID) continue;
            EntityAuton auton = new EntityAuton(world);
            auton.func_70107_b(randPosX, randPosY + 1, randPosZ);
            world.func_72838_d((Entity)auton);
            EntityCyberman cyberman = new EntityCyberman(world);
            cyberman.func_70107_b(randPosX + 6, randPosY + 1, randPosZ + 6);
            world.func_72838_d((Entity)cyberman);
        }
    }

    private void generateClassicTrees(World world, Random rand, int chunkX, int chunkZ) {
        for (int i = 0; i < 90; ++i) {
            int randPosZ;
            int randPosX = chunkX + 8;
            int randPosY = rand.nextInt(96);
            if (world.func_180495_p(new BlockPos(randPosX, randPosY, randPosZ = chunkZ + 8)) != DMBlocks.classic_grass) continue;
            new WorldGenClassicTree().generate(world, rand, randPosX, randPosY + 1, randPosZ);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int dimID = world.field_73011_w.getDimension();
        BlockPos chunkPos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        boolean prevLogging = ForgeModContainer.logCascadingWorldGeneration;
        ForgeModContainer.logCascadingWorldGeneration = false;
        if (dimID == DMConfig.DimensionIDs.Moon_Dimension_ID) {
            this.genTitaniumOre.func_180709_b(world, random, chunkPos.func_177982_a(random.nextInt(16), random.nextInt(108) + 10, random.nextInt(16)));
        }
        if (dimID == 0) {
            this.genSilicateOre.func_180709_b(world, random, chunkPos.func_177982_a(random.nextInt(16), random.nextInt(108) + 10, random.nextInt(16)));
            this.genSonicCrystalOre.func_180709_b(world, random, chunkPos.func_177982_a(random.nextInt(16), random.nextInt(128) + 10, random.nextInt(36)));
        }
        if (dimID == DMConfig.DimensionIDs.Varos_Dimension_ID) {
            this.genZeitonOre.func_180709_b(world, random, chunkPos.func_177982_a(random.nextInt(16), random.nextInt(108) + 10, random.nextInt(16)));
        }
        if (dimID == DMConfig.DimensionIDs.Minecraft_Classic_Dimension_ID) {
            this.generateClassicTrees(world, random, chunkX * 16, chunkZ * 16);
        }
        if ((dimID == DMConfig.DimensionIDs.Skaro_Dimension_ID || dimID == 0) && DMConfig.ServerSide.SPAWN_DALEKS) {
            this.spawnDaleks(world, random, chunkX * 16, chunkZ * 16);
        }
        ForgeModContainer.logCascadingWorldGeneration = prevLogging;
    }
}

