/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.init;

import com.swdteam.client.init.DMTextures;
import com.swdteam.utils.FileUtils;
import com.swdteam.utils.Graphics;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.Gui;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class DMFontRenderer {
    private static final List<String> CHARACTERS = Arrays.asList(FileUtils.loadStringFromStream(new DMTextures.ResourceData("thedalekmod:data/font_data.dat").getStream()).split(" "));
    private static DMTextures.ResourceData TEXTURE = DMTextures.getResource("textures/font/font.png");

    public static void drawString(String s, int x, int y, float ... rgba) {
        Graphics.bindTexture(TEXTURE.getResourceLocation());
        FloatBuffer color = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2816, (FloatBuffer)color);
        float alphaValue = color.get(3);
        float rValue = color.get(0);
        float gValue = color.get(1);
        float bValue = color.get(2);
        int previousTexture = GL11.glGetInteger((int)32873);
        if (rgba.length >= 3) {
            float alpha = 1.0f;
            if (rgba.length >= 4) {
                alpha = rgba[3];
            }
            GL11.glColor4f((float)rgba[0], (float)rgba[1], (float)rgba[2], (float)alpha);
        }
        for (int i = 0; i < s.length(); ++i) {
            int index = 1 + CHARACTERS.indexOf("" + s.charAt(i));
            if (s.charAt(i) == ' ') {
                index = 0;
            }
            int yOffset = index / 16;
            int xOffset = index - 16 * yOffset;
            float col = (float)index / 100.0f;
            if (index == -1) {
                yOffset = 1;
                xOffset = 15;
            }
            Gui.func_152125_a((int)(x + 8 * i), (int)y, (float)(xOffset * 8), (float)(yOffset * 8), (int)8, (int)8, (int)8, (int)8, (float)128.0f, (float)64.0f);
        }
        GL11.glColor4f((float)rValue, (float)gValue, (float)bValue, (float)alphaValue);
        Graphics.bindTexture(previousTexture);
    }

    public static void drawCenteredString(String s, int x, int y, float ... rgba) {
        DMFontRenderer.drawString(s, x - s.length() * 8 / 2, y, rgba);
    }

    public static void drawStringWithShadow(String s, int x, int y, float ... rgba) {
        float alpha = 1.0f;
        if (rgba.length >= 4) {
            alpha = rgba[3];
        }
        DMFontRenderer.drawString(s, x + 1, y + 1, 0.1f, 0.1f, 0.1f, alpha);
        DMFontRenderer.drawString(s, x, y, rgba);
    }
}

