/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.gui;

import com.swdteam.client.data.PlayerSessionData;
import com.swdteam.client.gui.GuiPlayerStats;
import com.swdteam.client.gui.GuiTitle;
import com.swdteam.main.TheDalekMod;
import com.swdteam.utils.Graphics;
import com.swdteam.utils.IOUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class GuiLeaderboard
extends GuiScreen {
    private List<PlayerSessionData> players = new ArrayList<PlayerSessionData>();
    private boolean display = false;

    public void func_73866_w_() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String json = IOUtils.getJsonFromURL("http://api.swdteam.co.uk/files/SWDEss/webpage/leaderboard.php");
                    ArrayList<PlayerSessionData> playerSessions = new ArrayList<PlayerSessionData>();
                    if (json != null && json.length() > 0) {
                        try {
                            PlayerSessionData[] weaponsData;
                            for (PlayerSessionData data : weaponsData = (PlayerSessionData[])TheDalekMod.GSON.fromJson(json, PlayerSessionData[].class)) {
                                playerSessions.add(data);
                            }
                            GuiLeaderboard.this.players = playerSessions;
                        }
                        catch (Exception e) {
                            TheDalekMod.LOG.catching((Throwable)e);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                GuiLeaderboard.this.display = true;
            }
        }).start();
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 138, this.field_146295_m - 34, 120, 20, "Back to Main Menu"));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 18, this.field_146295_m - 34, 120, 20, "Your Stats"));
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == 0) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiTitle());
        }
        if (button.field_146127_k == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiPlayerStats());
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73733_a(0, 32, this.field_146294_l, 40, -1728053248, 0);
        this.func_73733_a(0, this.field_146295_m - 56, this.field_146294_l, this.field_146295_m - 48, 0, -1728053248);
        this.func_73733_a(0, 32, this.field_146294_l, this.field_146295_m - 48, -1728053248, -1728053248);
        this.func_73732_a(this.field_146289_q, "Top 4 Players", this.field_146294_l / 2, 10, 0xFFFFFF);
        int xOffset = this.field_146294_l / 2 - 180;
        if (!this.display) {
            this.func_73732_a(this.field_146289_q, "Loading...", this.field_146294_l / 2, 50, 0xFFFFFF);
        } else if (!this.players.isEmpty()) {
            for (int i = 0; i < this.players.size() && i < 5 && i <= 3; ++i) {
                if (i + 1 == 3) {
                    xOffset = this.field_146294_l / 2 + 20;
                }
                int yOffset = (i + 1) % 2 == 0 ? this.field_146295_m / 2 - 31 : this.field_146295_m / 2 - 124;
                GuiLeaderboard.func_73734_a((int)(xOffset + 10 - 8), (int)(52 + yOffset - 8), (int)(xOffset + 25 + 150), (int)(52 + yOffset + 45), (int)-1728053248);
                this.func_73731_b(this.field_146289_q, "(" + (i + 1) + ") " + this.players.get(i).getUsername(), xOffset + 42, 52 + yOffset, 0xFFFFFF);
                this.func_73731_b(this.field_146289_q, "Runs: " + this.players.get(i).getRuns(), xOffset + 42, 62 + yOffset, 0xFFFFFF);
                String[] time = DurationFormatUtils.formatDuration((long)this.players.get(i).getTimePlayed(), (String)"d:HH:mm").split(":");
                this.func_73731_b(this.field_146289_q, "Time Spent: ", xOffset + 42, 72 + yOffset, 0xFFFFFF);
                this.func_73731_b(this.field_146289_q, time[0] + " days, " + time[1] + "hrs, " + time[2] + "mins", xOffset + 42, 84 + yOffset, 0xFFFFFF);
                Graphics.bindTexture(Graphics.getTextureForPlayer(this.players.get(i).getUsername()));
                GuiLeaderboard.func_146110_a((int)(xOffset + 10), (int)(50 + yOffset), (float)24.0f, (float)24.0f, (int)24, (int)24, (float)192.0f, (float)192.0f);
                GuiLeaderboard.func_146110_a((int)(xOffset + 10), (int)(50 + yOffset), (float)120.0f, (float)24.0f, (int)24, (int)24, (float)192.0f, (float)192.0f);
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }
}

