/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.dmapi.command;

import com.swdteam.dmapi.command.IHandlesCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HandlesCommandRegistry {
    private static List<String> command_identifiers = new ArrayList<String>();
    private static HashMap<String, IHandlesCommand> commands = new HashMap();

    public static void registerCommand(IHandlesCommand c) {
        commands.put(c.getCommandName().toLowerCase(), c);
    }

    public static void unregisterCommand(IHandlesCommand c) {
        commands.remove(c.getCommandName().toLowerCase());
    }

    public static void unregisterCommand(String s) {
        commands.remove(s.toLowerCase());
    }

    public static CommandResponse getCommand(String command) {
        String[] ss = new String[]{""};
        CommandResponse cr = null;
        IHandlesCommand c = commands.get(command.toLowerCase());
        if (c == null) {
            for (IHandlesCommand hc : commands.values()) {
                if (hc.getAlias() == null || !hc.getAlias().contains(command.toLowerCase()) || hc.hasParameters()) continue;
                cr = new CommandResponse(ss, hc);
                break;
            }
        } else if (!c.hasParameters()) {
            cr = new CommandResponse(ss, c);
        }
        if (cr == null) {
            block1: for (IHandlesCommand s : commands.values()) {
                String[] d = HandlesCommandRegistry.isCommand(command, s.getCommandName());
                if (d != null) {
                    cr = new CommandResponse(d, s);
                    break;
                }
                for (String s1 : s.getAlias()) {
                    d = HandlesCommandRegistry.isCommand(command, s1);
                    if (d == null || !s.hasParameters()) continue;
                    cr = new CommandResponse(d, s);
                    continue block1;
                }
            }
        }
        return cr;
    }

    public static String[] isCommand(String input, String command) {
        ArrayList<String> matches;
        String[] userInputArray = null;
        String patternFromTemplate = command;
        Pattern p1 = Pattern.compile("\\[(.*?)\\]");
        Matcher m1 = p1.matcher(patternFromTemplate);
        while (m1.find()) {
            patternFromTemplate = patternFromTemplate.replace("[" + m1.group(1) + "]", "(.*)");
        }
        Pattern p = Pattern.compile(patternFromTemplate, 2);
        Matcher m = p.matcher(input);
        if (m.matches()) {
            matches = new ArrayList<String>();
            int i = 1;
            while (i <= m.groupCount()) {
                matches.add(m.group(i));
                ++i;
            }
        } else {
            return null;
        }
        userInputArray = matches.toArray(new String[matches.size()]);
        return userInputArray;
    }

    public static void addCommandIdentifier(String s) {
        command_identifiers.add(s);
    }

    public static void removeCommandIdentifier(String s) {
        command_identifiers.remove(s);
    }

    public static HashMap<String, IHandlesCommand> getCommands() {
        return commands;
    }

    public static List<String> getCommandIdentifiers() {
        return command_identifiers;
    }

    public static class CommandResponse {
        private String[] args;
        private IHandlesCommand cmd;

        public CommandResponse(String[] args, IHandlesCommand cmd) {
            this.args = args;
            this.cmd = cmd;
        }

        public String[] getArgs() {
            return this.args;
        }

        public IHandlesCommand getCmd() {
            return this.cmd;
        }
    }
}

