/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.init;

import com.swdteam.common.init.DMTardisSkinReg;
import com.swdteam.common.tardis.TardisSaveHandler;
import com.swdteam.common.tardis.data.TardisData;
import com.swdteam.common.tardis.data.chameleon.ChameleonCircuitBase;
import com.swdteam.common.tileentity.tardis.perms.TardisPermission;
import com.swdteam.main.TheDalekMod;
import com.swdteam.main.config.DMConfig;
import com.swdteam.network.packets.PacketHandler;
import com.swdteam.network.packets.Packet_SendTardisData;
import com.swdteam.utils.Vector3;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.FMLInjectionData;

public class DMTardis {
    public static int INTERIOR_BOUNDS = 128;
    public static TardisData DEFAULT_DATA = new TardisData(0);
    public static HashMap<Integer, TardisData> tardises = new HashMap();
    public static List<ChameleonCircuitBase> ccTardisesAL = new ArrayList<ChameleonCircuitBase>();

    public static String[] getTardisSkinArray() {
        String[] s = new String[ccTardisesAL.size()];
        for (int i = 0; i < ccTardisesAL.size(); ++i) {
            ChameleonCircuitBase ccb = ccTardisesAL.get(i);
            s[i] = ccb.getExteriorName();
        }
        return s;
    }

    public static int addTardis(int exterior) {
        ChameleonCircuitBase exteriorCC = DMTardis.getTardisSkin(exterior);
        int tardisID = DMTardis.getFreeTardisID();
        int[] pos = new int[]{0, 0};
        pos[0] = tardisID;
        BlockPos p = DMTardis.getXZForMap(tardisID);
        BlockPos pos1 = new BlockPos(p.func_177958_n() * INTERIOR_BOUNDS, 58, p.func_177952_p() * INTERIOR_BOUNDS);
        TardisData data = new TardisData(tardisID);
        data.setTardisInteriorDoorLocation(new Vector3(pos1.func_177958_n() + exteriorCC.getSpawnOffsetPosition().x, exteriorCC.getSpawnOffsetPosition().y, pos1.func_177952_p() + exteriorCC.getSpawnOffsetPosition().z));
        data.setSpawnFacing(exteriorCC.getDefaultSpawnRotation());
        data.setTardisInteriorPosition(pos);
        data.setExteriorID(exterior);
        TardisSaveHandler.saveTardis(data);
        tardises.put(tardisID, data);
        WorldServer w = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(DMConfig.DimensionIDs.Tardis_Dimension_ID);
        DMTardis.getTardisSkin(data.getExteriorID()).generateInterior((World)w, pos1);
        TheDalekMod.LOG.info("[Dalek Mod] Added TARDIS: " + pos1.func_177958_n() + " | " + pos1.func_177952_p());
        return tardisID;
    }

    private static BlockPos getXZForMap(int np) {
        int dx = 0;
        int dy = 1;
        int segment_length = 1;
        int x = 0;
        int y = 0;
        int segment_passed = 0;
        if (np == 0) {
            return new BlockPos(x, 0, y);
        }
        for (int n = 0; n < np; ++n) {
            x += dx;
            y += dy;
            if (++segment_passed != segment_length) continue;
            segment_passed = 0;
            int buffer = dy;
            dy = -dx;
            dx = buffer;
            if (dx != 0) continue;
            ++segment_length;
        }
        return new BlockPos(x, 0, y);
    }

    public static int getFreeTardisID() {
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + FMLCommonHandler.instance().getMinecraftServerInstance().func_71270_I() + "/Tardis_Data/Tardises/";
        File f = new File(fileDir);
        if (!f.exists()) {
            f.mkdirs();
        }
        int id = f.listFiles().length + 1;
        while (DMTardis.doesTardisExist(id)) {
            ++id;
        }
        return id;
    }

    public static boolean doesTardisExist(int id) {
        if (tardises.containsKey(id)) {
            return true;
        }
        String fileDir = ((File)FMLInjectionData.data()[6]).getAbsolutePath() + "/saves/" + FMLCommonHandler.instance().getMinecraftServerInstance().func_71270_I() + "/Tardis_Data/Tardises/TardisData_" + id + ".json";
        return new File(fileDir).exists();
    }

    public static TardisData getTardis(int id) {
        return DMTardis.getTardis(true, id);
    }

    public static TardisData getTardis(boolean side, int id) {
        if (tardises.containsKey(id)) {
            return tardises.get(id);
        }
        if (side) {
            TardisData d = TardisSaveHandler.loadTardis(id);
            if (d != null) {
                tardises.put(id, d);
                return d;
            }
            return tardises.get(0);
        }
        return null;
    }

    public static HashMap<Integer, TardisData> getTardises() {
        return tardises;
    }

    public static void setTardises(HashMap<Integer, TardisData> tardises) {
        DMTardis.tardises = tardises;
    }

    public static void loadClientData(int tardisID, EntityPlayerMP player) {
        TardisData data = DMTardis.getTardis(tardisID);
        if (data == null) {
            data = new TardisData(0);
        }
        if (data != null) {
            PacketHandler.INSTANCE.sendTo((IMessage)new Packet_SendTardisData(data), player);
        }
    }

    public static void loadClientDataDim(int tardisID, int dim) {
        TardisData data = DMTardis.getTardis(tardisID);
        if (data == null) {
            data = new TardisData(0);
        }
        if (data != null) {
            PacketHandler.INSTANCE.sendToDimension((IMessage)new Packet_SendTardisData(data), dim);
        }
    }

    public static void addTardisFromData(TardisData d) {
        if (d != null) {
            tardises.put(d.getTardisID(), d);
        }
    }

    public static ChameleonCircuitBase addTardisSkin(ChameleonCircuitBase b) {
        if (ccTardisesAL.contains(b)) {
            TheDalekMod.LOG.info("[Dalek Mod] Tardis Already registered");
            return null;
        }
        ccTardisesAL.add(b);
        return b;
    }

    @Deprecated
    public static ChameleonCircuitBase getTardisSkin(String s) {
        for (ChameleonCircuitBase ccb : ccTardisesAL) {
            if (!ccb.getExteriorName().equalsIgnoreCase(s)) continue;
            return ccb;
        }
        return DMTardisSkinReg.SKIN_DEFAULT;
    }

    public static ChameleonCircuitBase getTardisSkin(int i) {
        if (i >= 0 && i < ccTardisesAL.size()) {
            return ccTardisesAL.get(i);
        }
        return DMTardisSkinReg.SKIN_DEFAULT;
    }

    public static boolean doesTardisSkinExist(String s) {
        for (ChameleonCircuitBase ccb : ccTardisesAL) {
            if (!ccb.getExteriorName().equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean doesTardisSkinExist(int i) {
        return i >= 0 && i < ccTardisesAL.size();
    }

    public static void removeTardis(int id) {
        if (tardises.containsKey(id)) {
            tardises.remove(id);
        }
    }

    public static boolean hasPermission(TardisData data, EntityPlayer p) {
        if (data.getTardisPermissions() == null) {
            data.setTardisPermissions(TardisPermission.NOBODY);
        }
        if (data.getCurrentOwner() == null && data.getOwner().equals(p.func_70005_c_())) {
            data.setCurrentOwner(p.func_110124_au());
        }
        switch (data.getTardisPermissions()) {
            case NOBODY: {
                if (data.getCurrentOwner() == null || !data.getCurrentOwner().equals(p.func_110124_au())) break;
                return true;
            }
            case COMPANIONS: {
                if ((data.getCurrentOwner() == null || !data.getCurrentOwner().equals(p.func_110124_au())) && !data.isCompanion(p)) break;
                return true;
            }
            case EVERYONE: {
                return true;
            }
        }
        return false;
    }

    public static int getNextFreeTardisChameleonID() {
        return ccTardisesAL.size();
    }
}

