/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.entity.dalek;

import com.swdteam.common.entity.EntityAuton;
import com.swdteam.common.entity.EntityCyberman;
import com.swdteam.common.entity.ai.DalekLaserAttack;
import com.swdteam.common.entity.dalek.IDalek;
import com.swdteam.common.init.DMDalekRegistry;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityDalek
extends EntityMob
implements IRangedAttackMob {
    public static final DataParameter<Integer> DALEK_TYPE = EntityDataManager.func_187226_a(EntityDalek.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DALEK_EXTRA_DATA = EntityDataManager.func_187226_a(EntityDalek.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityDalek(World world) {
        super(world);
        this.field_70178_ae = true;
        this.func_70105_a(0.8f, 1.8f);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.3));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCyberman.class, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityAuton.class, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityAnimal.class, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new DalekLaserAttack(this, 0.35, 25, 20, 5.0f));
        this.field_70765_h = new MoveHelper(this);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AILookAround(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIRandomFly(this));
    }

    public IDalek getDalekData() {
        IDalek dalek = null;
        int ID = (Integer)this.func_184212_Q().func_187225_a(DALEK_TYPE);
        dalek = ID >= DMDalekRegistry.getDaleks().size() || ID < 0 ? DMDalekRegistry.DEFAULT : DMDalekRegistry.getDaleks().get(ID);
        if (dalek == null) {
            dalek = DMDalekRegistry.DEFAULT;
        }
        return dalek;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return this.getDalekData().getHurtSound((Entity)this);
    }

    protected SoundEvent func_184639_G() {
        return this.getDalekData().getLivingSound((Entity)this);
    }

    protected SoundEvent func_184615_bR() {
        return this.getDalekData().getDeathSound((Entity)this);
    }

    public String func_70005_c_() {
        return this.getDalekData().getName();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        int idToUse = DMDalekRegistry.getDaleks().size() > 0 ? this.field_70170_p.field_73012_v.nextInt(DMDalekRegistry.getDaleks().size()) : 0;
        this.func_184212_Q().func_187214_a(DALEK_TYPE, (Object)idToUse);
        this.func_184212_Q().func_187214_a(DALEK_EXTRA_DATA, (Object)0);
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("dalek_id", ((Integer)this.func_184212_Q().func_187225_a(DALEK_TYPE)).intValue());
        par1NBTTagCompound.func_74768_a("extra_data", ((Integer)this.func_184212_Q().func_187225_a(DALEK_EXTRA_DATA)).intValue());
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74764_b("dalek_id")) {
            this.setDalekID(par1NBTTagCompound.func_74762_e("dalek_id"));
        } else {
            this.setDalekID(0);
        }
        if (par1NBTTagCompound.func_74764_b("extra_data")) {
            this.func_184212_Q().func_187227_b(DALEK_EXTRA_DATA, (Object)par1NBTTagCompound.func_74762_e("extra_data"));
        } else {
            this.func_184212_Q().func_187227_b(DALEK_EXTRA_DATA, (Object)0);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.getDalekData().onUpdate((Entity)this);
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (!this.getDalekData().CanFly()) {
            super.func_191986_a(strafe, vertical, forward);
        } else {
            if (this.func_70090_H()) {
                this.func_191958_b(strafe, vertical, forward, 0.02f);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)0.8f;
                this.field_70181_x *= (double)0.8f;
                this.field_70179_y *= (double)0.8f;
            } else if (this.func_180799_ab()) {
                this.func_191958_b(strafe, vertical, forward, 0.02f);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= 0.5;
                this.field_70181_x *= 0.5;
                this.field_70179_y *= 0.5;
            } else {
                float f = 0.91f;
                if (this.field_70122_E) {
                    BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                    IBlockState underState = this.field_70170_p.func_180495_p(underPos);
                    f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.91f;
                }
                float f1 = 0.16277136f / (f * f * f);
                this.func_191958_b(strafe, vertical, forward, this.field_70122_E ? 0.1f * f1 : 0.02f);
                f = 0.91f;
                if (this.field_70122_E) {
                    BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                    IBlockState underState = this.field_70170_p.func_180495_p(underPos);
                    f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.91f;
                }
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)f;
                this.field_70181_x *= (double)f;
                this.field_70179_y *= (double)f;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        }
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        this.getDalekData().onDeath((Entity)this);
        super.func_70645_a(par1DamageSource);
    }

    public void func_70071_h_() {
        if (!this.field_70122_E && this.getDalekData().CanFly() && this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 10; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.5 - 0.3, this.field_70163_u + 0.0, this.field_70161_v + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.5 - 0.2, 1.0, 1.0, 2.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.5 - 0.3, this.field_70163_u + 0.0, this.field_70161_v + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.5 - 0.2, 1.0, 1.0, 2.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + (this.field_70170_p.field_73012_v.nextDouble() + 0.5) * 0.5 - 0.3, this.field_70163_u + 0.0, this.field_70161_v + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.5 - 0.2, 1.0, 1.0, 2.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + (this.field_70170_p.field_73012_v.nextDouble() + 0.5) * 0.5 - 0.3, this.field_70163_u + 0.0, this.field_70161_v + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.5 - 0.2, 1.0, 1.0, 2.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + (this.field_70170_p.field_73012_v.nextDouble() + 0.5) * 0.5 - 0.3, this.field_70163_u + 0.0, this.field_70161_v + (this.field_70170_p.field_73012_v.nextDouble() + 0.5) * 0.5 - 0.2, 1.0, 1.0, 2.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + (this.field_70170_p.field_73012_v.nextDouble() + 0.5) * 0.5 - 0.3, this.field_70163_u + 0.0, this.field_70161_v + (this.field_70170_p.field_73012_v.nextDouble() + 0.5) * 0.5 - 0.2, 1.0, 1.0, 2.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.5 - 0.3, this.field_70163_u + 0.0, this.field_70161_v + (this.field_70170_p.field_73012_v.nextDouble() + 0.5) * 0.5 - 0.2, 1.0, 1.0, 2.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.5 - 0.3, this.field_70163_u + 0.0, this.field_70161_v + (this.field_70170_p.field_73012_v.nextDouble() + 0.5) * 0.5 - 0.2, 1.0, 1.0, 2.0, new int[0]);
            }
        }
        super.func_70071_h_();
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        this.getDalekData().onAttacked((Entity)this, (Entity)this.field_70717_bb, par1DamageSource);
        if (par1DamageSource.func_76346_g() != null) {
            this.func_70625_a(par1DamageSource.func_76346_g(), 1.0f, 1.0f);
        }
        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187602_cF, this.func_184176_by(), 1.0f, 1.0f, false);
        return super.func_70097_a(par1DamageSource, par2);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    public void func_82196_d(EntityLivingBase living, float distanceFactor) {
        this.getDalekData().onLaserAttack(this, living, distanceFactor);
    }

    protected float func_70599_aP() {
        return 3.0f;
    }

    public void setDalekID(int id) {
        this.func_184212_Q().func_187227_b(DALEK_TYPE, (Object)id);
    }

    public void setupDalek() {
        this.getDalekData().setupDalek((Entity)this);
    }

    public void func_184724_a(boolean swingingArms) {
    }

    static class AILookAround
    extends EntityAIBase {
        private final EntityDalek Dalek;

        public AILookAround(EntityDalek Dalek) {
            this.Dalek = Dalek;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.Dalek.func_70638_az() == null) {
                this.Dalek.field_70761_aq = this.Dalek.field_70177_z = -((float)MathHelper.func_181159_b((double)this.Dalek.field_70159_w, (double)this.Dalek.field_70179_y)) * 57.295776f;
            } else {
                EntityLivingBase entitylivingbase = this.Dalek.func_70638_az();
                double d0 = 64.0;
                if (entitylivingbase.func_70068_e((Entity)this.Dalek) < 4096.0) {
                    double d1 = entitylivingbase.field_70165_t - this.Dalek.field_70165_t;
                    double d2 = entitylivingbase.field_70161_v - this.Dalek.field_70161_v;
                    this.Dalek.field_70761_aq = this.Dalek.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }

    static class AIRandomFly
    extends EntityAIBase {
        private final EntityDalek Dalek;

        public AIRandomFly(EntityDalek Dalek) {
            this.Dalek = Dalek;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.Dalek.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.Dalek.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.Dalek.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.Dalek.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.Dalek.func_70681_au();
            double d0 = this.Dalek.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.Dalek.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.Dalek.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.Dalek.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
        }
    }

    static class MoveHelper
    extends EntityMoveHelper {
        private final EntityDalek Dalek;
        private int courseChangeCooldown;

        public MoveHelper(EntityDalek Dalek) {
            super((EntityLiving)Dalek);
            this.Dalek = Dalek;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - this.Dalek.field_70165_t;
                double d1 = this.field_75647_c - this.Dalek.field_70163_u;
                double d2 = this.field_75644_d - this.Dalek.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.Dalek.func_70681_au().nextInt(5) + 2;
                    if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3 = (double)MathHelper.func_76133_a((double)d3))) {
                        this.Dalek.field_70159_w += d0 / d3 * 0.1;
                        this.Dalek.field_70181_x += d1 / d3 * 0.1;
                        this.Dalek.field_70179_y += d2 / d3 * 0.1;
                    } else {
                        this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    }
                }
            }
        }

        private boolean isNotColliding(double x, double y, double z, double p_179926_7_) {
            double d0 = (x - this.Dalek.field_70165_t) / p_179926_7_;
            double d1 = (y - this.Dalek.field_70163_u) / p_179926_7_;
            double d2 = (z - this.Dalek.field_70161_v) / p_179926_7_;
            AxisAlignedBB axisalignedbb = this.Dalek.func_174813_aQ();
            int i = 1;
            while ((double)i < p_179926_7_) {
                if (!this.Dalek.field_70170_p.func_184144_a((Entity)this.Dalek, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

