/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.utils;

import com.swdteam.utils.Vector3;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldUtils {
    @SideOnly(value=Side.CLIENT)
    static float partialTicks;

    @SideOnly(value=Side.CLIENT)
    public static void setPartialTicks(float partialTicks) {
        WorldUtils.partialTicks = partialTicks;
    }

    @SideOnly(value=Side.CLIENT)
    public static float getPartialTicks() {
        return partialTicks;
    }

    public static List<Block> getBlocksWithinAxisAlignedBB(World w, AxisAlignedBB box) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        int x = (int)box.field_72340_a;
        while ((double)x <= box.field_72336_d) {
            int y = (int)box.field_72338_b;
            while ((double)y <= box.field_72337_e) {
                int z = (int)box.field_72339_c;
                while ((double)z <= box.field_72334_f) {
                    blocks.add(w.func_180495_p(new BlockPos(x, y, z)).func_177230_c());
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return blocks;
    }

    public static TileEntity getTileEntity(World world, int x, int y, int z) {
        return world.func_175625_s(new BlockPos(x, y, z));
    }

    public static Block getBlock(World world, int x, int y, int z) {
        return world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
    }

    public static boolean blockExists(World world, int x, int y, int z) {
        return world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == null;
    }

    public static BlockPos vec3ToBlockPos(Vector3 v) {
        return new BlockPos(v.getX(), v.getY(), v.getZ());
    }

    public static List<Block> getBlocksForLandingWithinBounds(World w, AxisAlignedBB box) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        int x = (int)box.field_72340_a;
        while ((double)x <= box.field_72336_d) {
            int y = (int)box.field_72338_b;
            while ((double)y <= box.field_72337_e) {
                int z = (int)box.field_72339_c;
                while ((double)z <= box.field_72334_f) {
                    IBlockState blockState = w.func_180495_p(new BlockPos(x, y, z));
                    Block b = blockState.func_177230_c();
                    if (b != Blocks.field_150350_a && b.func_149688_o(blockState) != Material.field_151585_k && b.func_149688_o(blockState) != Material.field_151582_l && b.func_149688_o(blockState) != Material.field_151597_y) {
                        blocks.add(b);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return blocks;
    }

    public static List<BlockWithPos> getBlocksWithinBounds(World w, AxisAlignedBB box) {
        ArrayList<BlockWithPos> blocks = new ArrayList<BlockWithPos>();
        int x = (int)box.field_72340_a;
        while ((double)x <= box.field_72336_d) {
            int y = (int)box.field_72338_b;
            while ((double)y <= box.field_72337_e) {
                int z = (int)box.field_72339_c;
                while ((double)z <= box.field_72334_f) {
                    BlockPos pos = new BlockPos(x, y, z);
                    Block b = w.func_180495_p(pos).func_177230_c();
                    blocks.add(new BlockWithPos(b, pos));
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return blocks;
    }

    public static void markBlockForUpdate(World world, BlockPos pos) {
        world.markAndNotifyBlock(pos, world.func_175726_f(pos), world.func_180495_p(pos), world.func_180495_p(pos), 1);
    }

    public static void playSoundByEntity(Entity entity, SoundEvent sound, SoundCategory cat) {
        WorldUtils.playSoundByEntity(entity, sound, cat, 1.0f, 1.0f);
    }

    public static void playSoundByEntity(Entity entity, SoundEvent sound, SoundCategory cat, float volume, float pitch) {
        entity.field_70170_p.func_184134_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, sound, SoundCategory.AMBIENT, volume, pitch, false);
    }

    public static boolean isInWorldBounds(Vector3 vec) {
        return vec.x > -29000000 && vec.x < 29000000 && vec.y < 255 && vec.y > 0 && vec.z > -29000000 && vec.z < 29000000;
    }

    public static class BlockWithPos {
        private BlockPos p;
        private Block b;

        public BlockWithPos(Block b, BlockPos p) {
            this.setBlock(b);
            this.setBlockPos(p);
        }

        public Block getBlock() {
            return this.b;
        }

        public BlockPos getBlockPos() {
            return this.p;
        }

        public void setBlock(Block b) {
            this.b = b;
        }

        public void setBlockPos(BlockPos p) {
            this.p = p;
        }
    }
}

