/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDMSlab
extends Block {
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);
    protected static final AxisAlignedBB AABB_BOTTOM_HALF = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_TOP_HALF = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    public IBlockState fullBlockState;

    public BlockDMSlab(IBlockState fullBlock, Material par1) {
        super(par1);
        this.fullBlockState = fullBlock;
        this.func_149711_c(1.0f);
        this.func_149672_a(fullBlock.func_177230_c().func_185467_w());
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumType.BOTTOM)));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (worldIn.func_180495_p(pos.func_177982_a(0, -1, 0)) == this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumType.BOTTOM))) {
            worldIn.func_175656_a(pos.func_177982_a(0, -1, 0), this.fullBlockState);
            worldIn.func_175698_g(pos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean p_185477_7_) {
        super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entity, p_185477_7_);
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return state.func_177229_b(TYPE) == EnumType.TOP;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return state.func_177229_b(TYPE) == EnumType.TOP ? AABB_TOP_HALF : AABB_BOTTOM_HALF;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.UP && state.func_177229_b(TYPE) == EnumType.TOP) {
            return BlockFaceShape.SOLID;
        }
        return face == EnumFacing.DOWN && state.func_177229_b(TYPE) == EnumType.BOTTOM ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (ForgeModContainer.disableStairSlabCulling) {
            return super.doesSideBlockRendering(state, world, pos, face);
        }
        EnumType side = (EnumType)((Object)state.func_177229_b(TYPE));
        return side == EnumType.TOP && face == EnumFacing.UP || side == EnumType.BOTTOM && face == EnumFacing.DOWN;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(TYPE, (Comparable)((Object)EnumType.BOTTOM));
        return facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? iblockstate : iblockstate.func_177226_a(TYPE, (Comparable)((Object)EnumType.TOP));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)(meta == 0 ? EnumType.TOP : EnumType.BOTTOM)));
    }

    public int func_176201_c(IBlockState state) {
        EnumType type = (EnumType)((Object)state.func_177229_b(TYPE));
        return type.getID();
    }

    public static enum EnumType implements IStringSerializable
    {
        TOP(0, "top"),
        BOTTOM(1, "bottom");

        private int ID;
        private String name;

        private EnumType(int ID, String name) {
            this.ID = ID;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getID() {
            return this.ID;
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

