/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.client.events;

import com.swdteam.common.init.DMBlocks;
import com.swdteam.common.tileentity.tardis.TileEntityTardis;
import com.swdteam.main.DM18BlockMap;
import com.swdteam.utils.FileUtils;
import com.swdteam.utils.world.TileData;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ChunkProviderClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;

public class ChunkEvents {
    public static State CHUNK_STATE = State.DISABLED;
    public List<ChunkPos> chunk_list = new ArrayList<ChunkPos>();
    public boolean initialLoad = false;

    @SubscribeEvent
    public void tickClient(TickEvent.ClientTickEvent e) {
        if (CHUNK_STATE == State.SAVE && e.side == Side.CLIENT) {
            ChunkProviderClient chunks;
            Object o;
            if (!this.initialLoad) {
                this.initialLoad = true;
                this.startThread();
            }
            if (Minecraft.func_71410_x().field_71441_e != null && (o = ReflectionHelper.getPrivateValue(ChunkProviderClient.class, (Object)(chunks = Minecraft.func_71410_x().field_71441_e.func_72863_F()), (int)3)) instanceof List) {
                List loadedChunks = (List)o;
                for (int i = 0; i < loadedChunks.size(); ++i) {
                    Chunk c = (Chunk)loadedChunks.get(i);
                    if (this.chunk_list.contains(new ChunkPos(c))) continue;
                    this.chunk_list.add(new ChunkPos(c));
                }
            }
        }
    }

    private void startThread() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                block0: while (true) {
                    int i = 0;
                    while (true) {
                        if (i >= ChunkEvents.this.chunk_list.size()) continue block0;
                        ChunkPos chunkPos = ChunkEvents.this.chunk_list.get(i);
                        if (chunkPos == null || chunkPos != null && chunkPos.chunk == null) {
                            System.out.println("Null Chunk");
                        } else if (!chunkPos.hasProcessed()) {
                            int[] blockArray = new int[65536];
                            byte[] boolArray = new byte[65536];
                            byte[] metaArray = new byte[65536];
                            ArrayList<TileData> tiles = new ArrayList<TileData>();
                            int index = 0;
                            for (int y = 0; y < 256; ++y) {
                                for (int x = 0; x < 16; ++x) {
                                    for (int z = 0; z < 16; ++z) {
                                        BlockPos pos = new BlockPos(x, y, z);
                                        IBlockState block = chunkPos.getChunk().func_177435_g(pos);
                                        if (block.func_177230_c() == DMBlocks.tardis) {
                                            block = Blocks.field_150350_a.func_176223_P();
                                        }
                                        if (DMBlocks.dmBlocks.contains(block.func_177230_c())) {
                                            boolArray[index] = 1;
                                            blockArray[index] = DMBlocks.dmBlocks.indexOf(block.func_177230_c());
                                        } else {
                                            boolArray[index] = 0;
                                            blockArray[index] = Block.func_149682_b((Block)block.func_177230_c());
                                        }
                                        TileEntity te = chunkPos.getChunk().func_177424_a(pos, Chunk.EnumCreateEntityType.IMMEDIATE);
                                        if (te != null && !(te instanceof TileEntityTardis)) {
                                            NBTTagCompound tag = new NBTTagCompound();
                                            te.func_189515_b(tag);
                                            TileData tileData = new TileData();
                                            tileData.setPos(new int[]{x, y, z});
                                            tileData.setNbtData(tag);
                                            tiles.add(tileData);
                                        }
                                        metaArray[index] = (byte)block.func_177230_c().func_176201_c(block);
                                        ++index;
                                    }
                                }
                            }
                            ChunkData data = new ChunkData();
                            data.setBlockMap(blockArray);
                            data.setBoolMap(boolArray);
                            data.setMetaMap(metaArray);
                            data.setName("chunk_" + chunkPos.getX() + "_" + chunkPos.getZ());
                            data.setTileData(tiles);
                            FileUtils.writeObjectToFile((Object)data, "ChunkData/" + data.getName() + ".chunk");
                            System.out.println("Saved: " + data.getName());
                            chunkPos.setProcessed(true);
                        }
                        ++i;
                    }
                    break;
                }
            }
        }).start();
    }

    public static class ServerSide {
        public List<ChunkPos> chunk_list = new ArrayList<ChunkPos>();

        @SubscribeEvent
        public void chunkLoad(ChunkEvent.Load e) {
            if (CHUNK_STATE == State.LOAD) {
                if (this.chunk_list.contains(new ChunkPos(e.getChunk()))) {
                    return;
                }
                this.loadChunk(e.getChunk());
            }
        }

        @SubscribeEvent
        public void chunkLoad(EntityEvent.EnteringChunk e) {
            if (CHUNK_STATE == State.LOAD && e.getEntity() instanceof EntityPlayer) {
                System.out.println(e.getNewChunkX());
                Chunk chunk = e.getEntity().func_130014_f_().func_72964_e(e.getNewChunkX(), e.getNewChunkZ());
                if (this.chunk_list.contains(new ChunkPos(chunk))) {
                    return;
                }
                this.loadChunk(chunk);
            }
        }

        public void loadChunk(Chunk chunk) {
            ChunkData data;
            chunk.func_177412_p().captureBlockSnapshots = true;
            File file = new File("ChunkData/chunk_" + chunk.field_76635_g + "_" + chunk.field_76647_h + ".chunk");
            if (file.exists() && (data = (ChunkData)FileUtils.loadObjectFromFile(file, ChunkData.class)) != null) {
                int i;
                int chunkSize = 65536;
                int index = 0;
                for (i = 0; i < chunkSize / 256; ++i) {
                    int y = i;
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            IBlockState state;
                            Block block;
                            BlockPos pos = new BlockPos(x, y, z);
                            if (data.boolMap[index] == 1) {
                                block = DM18BlockMap.getBlockForID(data.getBlockMap()[index]);
                                state = block.func_176223_P();
                                try {
                                    state = block.func_176203_a((int)data.getMetaMap()[index]);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (state == null) {
                                    state = block.func_176223_P();
                                }
                                chunk.func_177436_a(pos, state);
                            } else {
                                block = Block.func_149729_e((int)data.getBlockMap()[index]);
                                state = block.func_176203_a((int)data.getMetaMap()[index]);
                                chunk.func_177436_a(pos, state);
                            }
                            ++index;
                        }
                    }
                }
                for (i = 0; i < data.getTileData().size(); ++i) {
                    NBTTagCompound tag;
                    TileData tileData = data.getTileData().get(i);
                    TileEntity t = chunk.func_177424_a(new BlockPos(tileData.getPos()[0], tileData.getPos()[1], tileData.getPos()[2]), Chunk.EnumCreateEntityType.IMMEDIATE);
                    if (t == null || (tag = tileData.getNbtData()) == null) continue;
                    t.func_145839_a(tag);
                }
                System.out.println("Loaded: " + file.getName());
                this.chunk_list.add(new ChunkPos(chunk));
            }
        }
    }

    public static class ChunkData {
        private int[] blockMap;
        private byte[] metaMap;
        private byte[] boolMap;
        private boolean processed;
        private String name;
        private List<TileData> tileData = new ArrayList<TileData>();

        public void setMetaMap(byte[] metaArray) {
            this.metaMap = metaArray;
        }

        public void setBlockMap(int[] blockMap) {
            this.blockMap = blockMap;
        }

        public void setBoolMap(byte[] boolMap) {
            this.boolMap = boolMap;
        }

        public int[] getBlockMap() {
            return this.blockMap;
        }

        public byte[] getBoolMap() {
            return this.boolMap;
        }

        public byte[] getMetaMap() {
            return this.metaMap;
        }

        public void setProcessed(boolean processed) {
            this.processed = processed;
        }

        public boolean isProcessed() {
            return this.processed;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<TileData> getTileData() {
            return this.tileData;
        }

        public void setTileData(List<TileData> tileData) {
            this.tileData = tileData;
        }
    }

    public static class ChunkPos {
        private int x;
        private int z;
        private Chunk chunk;
        private boolean processed = false;

        public ChunkPos(Chunk c) {
            this.x = c.field_76635_g;
            this.z = c.field_76647_h;
            this.chunk = c;
        }

        public int getX() {
            return this.x;
        }

        public int getZ() {
            return this.z;
        }

        public Chunk getChunk() {
            return this.chunk;
        }

        public boolean equals(Object obj) {
            return obj instanceof ChunkPos && this.x == ((ChunkPos)obj).getX() && this.z == ((ChunkPos)obj).getZ();
        }

        public boolean hasProcessed() {
            return this.processed;
        }

        public void setProcessed(boolean processed) {
            this.processed = processed;
        }
    }

    public static enum State {
        SAVE,
        LOAD,
        DISABLED;

    }
}

